/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.models.obj.IEOBJModel;
import blusunrize.immersiveengineering.client.models.obj.callback.DefaultCallback;
import blusunrize.immersiveengineering.client.models.obj.callback.IEOBJCallback;
import blusunrize.immersiveengineering.client.models.obj.callback.IEOBJCallbacks;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.annotation.Nullable;
import malte0811.modelsplitter.model.MaterialLibrary;
import malte0811.modelsplitter.model.OBJModel;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.client.model.geometry.IGeometryLoader;

public class IEOBJLoader
implements IGeometryLoader<IEOBJModel> {
    public static final ResourceLocation LOADER_NAME = new ResourceLocation("immersiveengineering", "ie_obj");
    public static final String MODEL_KEY = "model";
    public static final String CALLBACKS_KEY = "callbacks";
    public static final String DYNAMIC_KEY = "dynamic";
    public static final String LAYERS_KEY = "layers";
    public static final IEOBJLoader instance = new IEOBJLoader();

    public IEOBJModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) throws JsonParseException {
        IEOBJModel iEOBJModel;
        block12: {
            ResourceLocation modelLoc = IEOBJLoader.toRL(modelContents.get(MODEL_KEY).getAsString(), null);
            InputStream input = this.getStream(modelLoc);
            try {
                IEOBJCallback<?> callback;
                OBJModel<MaterialLibrary.OBJMaterial> model = OBJModel.readFromStream(input, s -> this.getStream(IEOBJLoader.toRL(s, modelLoc))).quadify().recomputeZeroNormals();
                if (modelContents.has(CALLBACKS_KEY)) {
                    String key = modelContents.get(CALLBACKS_KEY).getAsString();
                    callback = IEOBJCallbacks.getCallback(new ResourceLocation(key));
                } else {
                    callback = DefaultCallback.INSTANCE;
                }
                boolean dynamic = modelContents.has(DYNAMIC_KEY) && modelContents.get(DYNAMIC_KEY).getAsBoolean();
                ArrayList<ResourceLocation> layers = null;
                if (modelContents.has(LAYERS_KEY)) {
                    layers = new ArrayList<ResourceLocation>();
                    for (JsonElement entry : modelContents.getAsJsonArray(LAYERS_KEY)) {
                        layers.add(new ResourceLocation(entry.getAsString()));
                    }
                }
                iEOBJModel = new IEOBJModel(model, dynamic, callback, layers);
                if (input == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            input.close();
        }
        return iEOBJModel;
    }

    private static ResourceLocation toRL(String name, @Nullable ResourceLocation basePath) {
        if (name.contains(":")) {
            return new ResourceLocation(name);
        }
        if (basePath != null) {
            String baseDir = basePath.m_135815_().substring(0, basePath.m_135815_().lastIndexOf(47) + 1);
            return new ResourceLocation(basePath.m_135827_(), baseDir + name);
        }
        return ImmersiveEngineering.rl(name);
    }

    private InputStream getStream(ResourceLocation path) {
        try {
            return ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(path).orElseThrow()).m_215507_();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

