/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.conveyor.ClientConveyors;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorWall;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorBelt;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorModelRender;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBlock;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;

public class ModelConveyor<T extends IConveyorBelt>
extends BakedIEModel {
    private static final ModelProperty<IConveyorBelt> CONVEYOR_MODEL_DATA = new ModelProperty();
    public static final ResourceLocation[] rl_casing = new ResourceLocation[]{new ResourceLocation("immersiveengineering", "block/conveyor/casing_top"), new ResourceLocation("immersiveengineering", "block/conveyor/casing_side"), new ResourceLocation("immersiveengineering", "block/conveyor/casing_walls"), new ResourceLocation("immersiveengineering", "block/conveyor/casing_full")};
    private final Cache<Object, List<BakedQuad>> modelCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private final IConveyorType<T> type;
    private final Block fallbackCover;
    TextureAtlasSprite tex_particle;
    private static final ItemOverrides overrideList = new ItemOverrides(){
        private final LoadingCache<Key, BakedModel> itemModelCache = CacheBuilder.newBuilder().maximumSize(100L).build(CacheLoader.from(key -> new ModelConveyor(key.type(), key.defaultCover())));

        public BakedModel m_173464_(@Nonnull BakedModel originalModel, @Nonnull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int unused) {
            BlockItem asBlock;
            Block b;
            IConveyorType<?> conveyorType;
            Item item = stack.m_41720_();
            if (item instanceof BlockItem && (conveyorType = ConveyorHandler.getType(b = (asBlock = (BlockItem)item).m_40614_())) != null) {
                Block defaultCover = ConveyorBlock.getCover(stack);
                return (BakedModel)this.itemModelCache.getUnchecked((Object)new Key(conveyorType, defaultCover));
            }
            return Minecraft.m_91087_().m_91304_().m_119409_();
        }

        record Key(IConveyorType<?> type, Block defaultCover) {
        }
    };
    private static final Map<ItemTransforms.TransformType, Transformation> TRANSFORMATION_MAP;

    public ModelConveyor(IConveyorType<T> type, Block fallbackCover) {
        this.type = type;
        this.fallbackCover = fallbackCover;
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
        IConveyorModelRender.RenderContext<Object> context;
        IConveyorModelRender<Object> clientData;
        Object key;
        List<BakedQuad> cachedQuads;
        Direction facing = Direction.NORTH;
        IConveyorBelt conveyor = null;
        if (blockState != null) {
            BlockEntity tile;
            facing = (Direction)blockState.m_61143_((Property)IEProperties.FACING_HORIZONTAL);
            if (extraData.has(CONVEYOR_MODEL_DATA)) {
                conveyor = (IConveyorBelt)extraData.get(CONVEYOR_MODEL_DATA);
            }
            if (conveyor != null && (tile = conveyor.getBlockEntity()) instanceof IEBlockInterfaces.IDirectionalBE) {
                facing = ((IEBlockInterfaces.IDirectionalBE)tile).getFacing();
            }
        }
        if ((cachedQuads = (List<BakedQuad>)this.modelCache.getIfPresent(key = (clientData = ClientConveyors.getData(this.type)).getModelCacheKey(context = new IConveyorModelRender.RenderContext<Object>((IConveyorType<Object>)this.type, conveyor, this.fallbackCover)))) == null) {
            cachedQuads = Collections.synchronizedList(Lists.newArrayList());
            Transformation matrix = ClientUtils.rotateTo(facing);
            matrix = clientData.modifyBaseRotationMatrix(matrix);
            ConveyorHandler.ConveyorDirection conDir = conveyor != null ? conveyor.getConveyorDirection() : ConveyorHandler.ConveyorDirection.HORIZONTAL;
            boolean[] walls = new boolean[]{clientData.shouldRenderWall(facing, ConveyorWall.LEFT, context), clientData.shouldRenderWall(facing, ConveyorWall.RIGHT, context)};
            TextureAtlasSprite tex_conveyor = ClientUtils.getSprite(context.isActiveOr(false) ? clientData.getActiveTexture() : clientData.getInactiveTexture());
            DyeColor colourStripes = null;
            TextureAtlasSprite tex_conveyor_colour = null;
            if (conveyor != null && (colourStripes = conveyor.getDyeColour()) != null) {
                tex_conveyor_colour = ClientUtils.getSprite(clientData.getColouredStripesTexture());
            }
            cachedQuads.addAll(ModelConveyor.getBaseConveyor(facing, 1.0f, matrix, conDir, tex_conveyor, walls, new boolean[]{true, true}, tex_conveyor_colour, colourStripes));
            cachedQuads = clientData.modifyQuads(cachedQuads, context);
            this.modelCache.put(key, (Object)ImmutableList.copyOf(cachedQuads));
        }
        return ImmutableList.copyOf((Collection)cachedQuads);
    }

    public static List<BakedQuad> getBaseConveyor(Direction facing, float length, Transformation matrix, ConveyorHandler.ConveyorDirection conDir, TextureAtlasSprite tex_conveyor, boolean[] walls, boolean[] corners, TextureAtlasSprite tex_conveyor_colour, @Nullable DyeColor stripeColour) {
        int i;
        int i2;
        Vec3 tmp;
        Vec3 v;
        int i3;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3[] vertices = new Vec3[]{new Vec3(0.0625, 0.0, (double)(1.0f - length)), new Vec3(0.0625, 0.0, 1.0), new Vec3(0.9375, 0.0, 1.0), new Vec3(0.9375, 0.0, (double)(1.0f - length))};
        TextureAtlasSprite tex_casing0 = ClientUtils.getSprite(rl_casing[0]);
        TextureAtlasSprite tex_casing1 = ClientUtils.getSprite(rl_casing[1]);
        TextureAtlasSprite tex_casing2 = ClientUtils.getSprite(rl_casing[2]);
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] colourStripes = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        if (stripeColour != null) {
            System.arraycopy(stripeColour.m_41068_(), 0, colourStripes, 0, 3);
        }
        TextureAtlasSprite topTexture = tex_conveyor_colour != null ? tex_conveyor_colour : tex_casing2;
        float[] topColor = stripeColour != null ? colourStripes : colour;
        for (i3 = 0; i3 < 4; ++i3) {
            if (!(i3 == 0 || i3 == 3 ? conDir == ConveyorHandler.ConveyorDirection.UP : conDir == ConveyorHandler.ConveyorDirection.DOWN)) continue;
            vertices[i3] = vertices[i3].m_82520_(0.0, (double)length, 0.0);
        }
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.DOWN, facing), tex_conveyor, new double[]{1.0, 0.0, 15.0, length * 16.0f}, colour, true));
        for (i3 = 0; i3 < vertices.length; ++i3) {
            v = vertices[i3];
            vertices[i3] = new Vec3(v.f_82479_ < 0.5 ? 0.0 : 1.0, v.f_82480_, v.f_82481_);
        }
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.DOWN, facing), tex_casing2, new double[]{0.0, 0.0, 16.0, length * 16.0f}, colour, true));
        for (i3 = 0; i3 < vertices.length; ++i3) {
            vertices[i3] = vertices[i3].m_82520_(0.0, 0.125, 0.0);
        }
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.UP, facing), tex_conveyor, new double[]{0.0, length * 16.0f, 16.0, 0.0}, colour, false));
        if (corners[0]) {
            vertices = new Vec3[]{new Vec3(0.0, 0.1875, 0.9375), new Vec3(0.0, 0.1875, 1.0), new Vec3(1.0, 0.1875, 1.0), new Vec3(1.0, 0.1875, 0.9375)};
            for (i3 = 0; i3 < 4; ++i3) {
                vertices[i3] = vertices[i3].m_82520_(0.0, i3 == 0 || i3 == 3 ? (double)(conDir == ConveyorHandler.ConveyorDirection.UP ? 0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? length - 0.0625f : 0.0f)) : (double)(conDir == ConveyorHandler.ConveyorDirection.DOWN ? length : 0.0f), 0.0);
            }
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.UP, facing), topTexture, new double[]{0.0, 1.0, 16.0, 0.0}, topColor, false));
        }
        if (corners[1]) {
            vertices = new Vec3[]{new Vec3(0.0, 0.1875, (double)(1.0f - length)), new Vec3(0.0, 0.1875, (double)(1.0625f - length)), new Vec3(1.0, 0.1875, (double)(1.0625f - length)), new Vec3(1.0, 0.1875, (double)(1.0f - length))};
            for (i3 = 0; i3 < 4; ++i3) {
                vertices[i3] = vertices[i3].m_82520_(0.0, i3 == 1 || i3 == 2 ? (double)(conDir == ConveyorHandler.ConveyorDirection.UP ? length - 0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? 0.0625f : 0.0f)) : (double)(conDir == ConveyorHandler.ConveyorDirection.UP ? length : 0.0f), 0.0);
            }
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.UP, facing), topTexture, new double[]{0.0, 1.0, 16.0, 0.0}, topColor, false));
        }
        vertices = new Vec3[]{new Vec3(0.0, 0.0, (double)(1.0f - length)), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.125, 1.0), new Vec3(0.0, 0.125, (double)(1.0f - length))};
        for (i3 = 0; i3 < 4; ++i3) {
            if (!(i3 == 0 || i3 == 3 ? conDir == ConveyorHandler.ConveyorDirection.UP : conDir == ConveyorHandler.ConveyorDirection.DOWN)) continue;
            vertices[i3] = vertices[i3].m_82520_(0.0, (double)length, 0.0);
        }
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing1, new double[]{0.0, 0.0, 2.0, length * 16.0f}, colour, false));
        for (i3 = 0; i3 < 4; ++i3) {
            v = vertices[i3];
            vertices[i3] = new Vec3(1.0, v.f_82480_, v.f_82481_);
        }
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing1, new double[]{0.0, 0.0, 2.0, length * 16.0f}, colour, true));
        for (i3 = 0; i3 < 4; ++i3) {
            v = vertices[i3];
            vertices[i3] = new Vec3(v.f_82479_, v.f_82480_ + (double)(i3 == 0 || i3 == 1 ? 0.125f : 0.0625f), v.f_82481_);
        }
        if (corners[0]) {
            vertices = new Vec3[]{new Vec3(0.0, 0.125, 0.9375), new Vec3(0.0, 0.125, 1.0), new Vec3(0.0, 0.1875, 1.0), new Vec3(0.0, 0.1875, 0.9375)};
            if (conDir != ConveyorHandler.ConveyorDirection.HORIZONTAL) {
                for (i3 = 0; i3 < 4; ++i3) {
                    vertices[i3] = vertices[i3].m_82520_(0.0, i3 == 0 || i3 == 3 ? (double)(conDir == ConveyorHandler.ConveyorDirection.UP ? 0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? length - 0.0625f : 0.0f)) : (double)(conDir == ConveyorHandler.ConveyorDirection.DOWN ? length : 0.0f), 0.0);
                }
            }
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing0, new double[]{0.0, 0.0, 1.0, 1.0}, colour, false));
            for (i3 = 0; i3 < vertices.length; ++i3) {
                vertices[i3] = vertices[i3].m_82520_(0.0625, 0.0, 0.0);
            }
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing0, new double[]{0.0, 0.0, 1.0, 1.0}, colour, true));
            for (i3 = 0; i3 < vertices.length; ++i3) {
                tmp = vertices[i3];
                vertices[i3] = new Vec3(1.0, tmp.f_82480_, tmp.f_82481_);
            }
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing0, new double[]{0.0, 0.0, 1.0, 1.0}, colour, true));
            for (i3 = 0; i3 < vertices.length; ++i3) {
                vertices[i3] = vertices[i3].m_82520_(-0.0625, 0.0, 0.0);
            }
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing0, new double[]{0.0, 0.0, 1.0, 1.0}, colour, false));
        }
        if (corners[1]) {
            vertices = new Vec3[]{new Vec3(0.0, 0.125, (double)(1.0f - length)), new Vec3(0.0, 0.125, (double)(1.0625f - length)), new Vec3(0.0, 0.1875, (double)(1.0625f - length)), new Vec3(0.0, 0.1875, (double)(1.0f - length))};
            if (conDir != ConveyorHandler.ConveyorDirection.HORIZONTAL) {
                for (i3 = 0; i3 < 4; ++i3) {
                    vertices[i3] = vertices[i3].m_82520_(0.0, i3 == 1 || i3 == 2 ? (double)(conDir == ConveyorHandler.ConveyorDirection.UP ? length - 0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? 0.0625f : 0.0f)) : (double)(conDir == ConveyorHandler.ConveyorDirection.UP ? length : 0.0f), 0.0);
                }
            }
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing0, new double[]{0.0, 15.0, 1.0, 16.0}, colour, false));
            for (i3 = 0; i3 < vertices.length; ++i3) {
                vertices[i3] = vertices[i3].m_82520_(0.0625, 0.0, 0.0);
            }
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing0, new double[]{0.0, 15.0, 1.0, 16.0}, colour, true));
            for (i3 = 0; i3 < vertices.length; ++i3) {
                tmp = vertices[i3];
                vertices[i3] = new Vec3(1.0, tmp.f_82480_, tmp.f_82481_);
            }
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing0, new double[]{0.0, 15.0, 1.0, 16.0}, colour, true));
            for (i3 = 0; i3 < vertices.length; ++i3) {
                vertices[i3] = vertices[i3].m_82520_(-0.0625, 0.0, 0.0);
            }
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing0, new double[]{0.0, 15.0, 1.0, 16.0}, colour, false));
        }
        vertices = new Vec3[]{new Vec3(0.0625, 0.0, (double)(1.0f - length)), new Vec3(0.0625, 0.125, (double)(1.0f - length)), new Vec3(0.9375, 0.125, (double)(1.0f - length)), new Vec3(0.9375, 0.0, (double)(1.0f - length))};
        if (conDir == ConveyorHandler.ConveyorDirection.UP) {
            for (i3 = 0; i3 < vertices.length; ++i3) {
                vertices[i3] = vertices[i3].m_82520_(0.0, (double)length, 0.0);
            }
        }
        double frontUMax = (1.0f - length) * 16.0f;
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), facing, tex_conveyor, new double[]{1.0, frontUMax + 2.0, 15.0, frontUMax}, colour, false));
        for (i2 = 0; i2 < 4; ++i2) {
            vertices[i2] = new Vec3(vertices[i2].m_7096_() < 0.5 ? 0.0 : 1.0, vertices[i2].m_7098_() + (double)(i2 == 1 || i2 == 2 ? 0.0625f : 0.0f), vertices[i2].f_82481_);
        }
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), facing, tex_casing2, new double[]{0.0, 3.0, 16.0, 0.0}, colour, false));
        for (i2 = 0; i2 < vertices.length; ++i2) {
            vertices[i2] = vertices[i2].m_82520_(0.0, (double)(conDir == ConveyorHandler.ConveyorDirection.UP ? -0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? 0.0625f : 0.0f)), 0.0625);
        }
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), facing, tex_casing2, new double[]{0.0, 3.0, 16.0, 0.0}, colour, true));
        for (i2 = 0; i2 < 4; ++i2) {
            Vec3 v2 = vertices[i2];
            v2 = new Vec3(v2.m_7096_() < 0.5 ? 0.0625 : 0.9375, v2.m_7098_() - (double)(i2 == 1 || i2 == 2 ? 0.0625f : 0.0f), v2.f_82481_);
            if (conDir == ConveyorHandler.ConveyorDirection.UP) {
                v2 = v2.m_82520_(0.0, (double)(-(length - 0.0625f)), 0.0);
            }
            if (conDir == ConveyorHandler.ConveyorDirection.DOWN) {
                v2 = v2.m_82520_(0.0, (double)(length - 0.0625f), 0.0);
            }
            vertices[i2] = v2 = v2.m_82520_(0.0, 0.0, (double)(length - 0.0625f));
        }
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), facing.m_122424_(), tex_conveyor, new double[]{1.0, 0.0, 15.0, 2.0}, colour, true));
        for (i2 = 0; i2 < 4; ++i2) {
            vertices[i2] = new Vec3(vertices[i2].m_7096_() < 0.5 ? 0.0 : 1.0, vertices[i2].m_7098_() + (double)(i2 == 1 || i2 == 2 ? 0.0625f : 0.0f), vertices[i2].f_82481_);
        }
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), facing.m_122424_(), tex_casing2, new double[]{0.0, 0.0, 16.0, 3.0}, colour, true));
        for (i2 = 0; i2 < vertices.length; ++i2) {
            vertices[i2] = vertices[i2].m_82520_(0.0, conDir == ConveyorHandler.ConveyorDirection.UP ? 0.0625 : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? -0.0625 : 0.0), -0.0625);
        }
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), facing.m_122424_(), tex_casing2, new double[]{0.0, 0.0, 16.0, 3.0}, colour, false));
        float wallLength = length - 0.125f;
        vertices = new Vec3[]{new Vec3(0.0, 0.1875, (double)(0.9375f - wallLength)), new Vec3(0.0, 0.1875, 0.9375), new Vec3(0.0625, 0.1875, 0.9375), new Vec3(0.0625, 0.1875, (double)(0.9375f - wallLength))};
        Vec3[] vertices2 = new Vec3[]{new Vec3(0.0, 0.125, (double)(0.9375f - wallLength)), new Vec3(0.0, 0.125, 0.9375), new Vec3(0.0, 0.1875, 0.9375), new Vec3(0.0, 0.1875, (double)(0.9375f - wallLength))};
        Vec3[] vertices3 = new Vec3[]{new Vec3(0.0625, 0.125, (double)(0.9375f - wallLength)), new Vec3(0.0625, 0.125, 0.9375), new Vec3(0.0625, 0.1875, 0.9375), new Vec3(0.0625, 0.1875, (double)(0.9375f - wallLength))};
        for (i = 0; i < 4; ++i) {
            if (conDir == ConveyorHandler.ConveyorDirection.HORIZONTAL) continue;
            float f = i == 0 || i == 3 ? (conDir == ConveyorHandler.ConveyorDirection.UP ? length - 0.0625f : 0.0625f) : (conDir == ConveyorHandler.ConveyorDirection.UP ? 0.0625f : length - 0.0625f);
            vertices[i] = vertices[i].m_82520_(0.0, (double)f, 0.0);
            vertices2[i] = vertices2[i].m_82520_(0.0, (double)f, 0.0);
            vertices3[i] = vertices3[i].m_82520_(0.0, (double)f, 0.0);
        }
        if (walls[0]) {
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.UP, facing), topTexture, new double[]{0.0, 15.0, 1.0, 1.0}, topColor, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices2), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing1, new double[]{2.0, 15.0, 3.0, 1.0}, colour, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices3), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing1, new double[]{2.0, 15.0, 3.0, 1.0}, colour, true));
        }
        for (i = 0; i < 4; ++i) {
            vertices[i] = vertices[i].m_82520_(0.9375, 0.0, 0.0);
            vertices2[i] = vertices2[i].m_82520_(0.9375, 0.0, 0.0);
            vertices3[i] = vertices3[i].m_82520_(0.9375, 0.0, 0.0);
        }
        if (walls[1]) {
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.UP, facing), topTexture, new double[]{15.0, 15.0, 16.0, 1.0}, topColor, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices2), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing1, new double[]{2.0, 15.0, 3.0, 1.0}, colour, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertices3), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing1, new double[]{2.0, 15.0, 3.0, 1.0}, colour, true));
        }
        return quads;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        if (this.tex_particle == null) {
            this.tex_particle = ClientUtils.getSprite(new ResourceLocation("immersiveengineering", "block/conveyor/off"));
        }
        return this.tex_particle;
    }

    @Nonnull
    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return overrideList;
    }

    @Nonnull
    public BakedModel applyTransform(ItemTransforms.TransformType transformType, PoseStack stack, boolean applyLeftHandTransform) {
        Transformation transform = TRANSFORMATION_MAP.get(transformType);
        if (transform != null) {
            Vector3f translate = transform.m_175940_();
            stack.m_85837_((double)translate.m_122239_(), (double)translate.m_122260_(), (double)translate.m_122269_());
            stack.m_85845_(transform.m_121105_());
            Vector3f scale = transform.m_175941_();
            stack.m_85841_(scale.m_122239_(), scale.m_122260_(), scale.m_122269_());
            stack.m_85845_(transform.m_175942_());
        }
        return this;
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        Block b = state.m_60734_();
        IConveyorType<?> conveyorName = ConveyorHandler.getType(b);
        if (conveyorName == null) {
            return tileData;
        }
        BlockEntity bEntity = world.m_7702_(pos);
        if (!(bEntity instanceof ConveyorHandler.IConveyorBlockEntity)) {
            return tileData;
        }
        return tileData.derive().with(CONVEYOR_MODEL_DATA, ConveyorHandler.getConveyor(conveyorName, bEntity)).build();
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        return List.of(ForgeRenderTypes.ITEM_LAYERED_CUTOUT.get());
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()});
    }

    static {
        EnumMap<ItemTransforms.TransformType, Matrix4> matrixMap = new EnumMap<ItemTransforms.TransformType, Matrix4>(ItemTransforms.TransformType.class);
        matrixMap.put(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, new Matrix4().scale(0.5, 0.5, 0.5).translate(0.0, 0.25, 0.0).rotate(Math.toRadians(-45.0), 0.0, 1.0, 0.0));
        matrixMap.put(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, new Matrix4().scale(0.5, 0.5, 0.5).translate(0.0, 0.25, 0.0).rotate(Math.toRadians(-45.0), 0.0, 1.0, 0.0));
        matrixMap.put(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, new Matrix4().translate(0.0, 0.0625, -0.125).scale(0.3125, 0.3125, 0.3125).rotate(Math.toRadians(30.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(130.0), 0.0, 1.0, 0.0));
        matrixMap.put(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, new Matrix4().translate(0.0, 0.0625, -0.125).scale(0.3125, 0.3125, 0.3125).rotate(Math.toRadians(30.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(130.0), 0.0, 1.0, 0.0));
        matrixMap.put(ItemTransforms.TransformType.GUI, new Matrix4().scale(0.625, 0.625, 0.625).rotate(Math.toRadians(-45.0), 0.0, 1.0, 0.0).rotate(Math.toRadians(-20.0), 0.0, 0.0, 1.0).rotate(Math.toRadians(20.0), 1.0, 0.0, 0.0));
        matrixMap.put(ItemTransforms.TransformType.FIXED, new Matrix4().scale(0.625, 0.625, 0.625).rotate(Math.PI, 0.0, 1.0, 0.0).translate(0.0, 0.0, 0.3125));
        matrixMap.put(ItemTransforms.TransformType.GROUND, new Matrix4().scale(0.25, 0.25, 0.25));
        TRANSFORMATION_MAP = matrixMap.entrySet().stream().map(e -> Pair.of((Object)((ItemTransforms.TransformType)e.getKey()), (Object)((Matrix4)e.getValue()).toTransformationMatrix())).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public static class ConveyorLoader
    implements IGeometryLoader<RawConveyorModel> {
        public static final ResourceLocation LOCATION = new ResourceLocation("immersiveengineering", "models/conveyor");
        public static final String TYPE_KEY = "conveyorType";

        @Nonnull
        public RawConveyorModel read(JsonObject modelContents, @Nonnull JsonDeserializationContext deserializationContext) {
            String typeName = modelContents.get(TYPE_KEY).getAsString();
            IConveyorType<?> type = ConveyorHandler.getConveyorType(new ResourceLocation(typeName));
            return new RawConveyorModel(Objects.requireNonNull(type));
        }
    }

    public record RawConveyorModel(IConveyorType<?> type) implements IUnbakedGeometry<RawConveyorModel>
    {
        public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
            return new ModelConveyor(this.type, Blocks.f_50016_);
        }

        public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return ImmutableList.of();
        }
    }
}

