/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;

public class AveragingEnergyStorage
extends MutableEnergyStorage {
    private int averageInsertion = 0;
    private int averageExtraction = 0;
    private static final double AVERAGE_DECAY_FACTOR = 0.5;
    private int tickInsert = 0;
    private int tickExtract = 0;

    public AveragingEnergyStorage(int capacity) {
        super(capacity);
    }

    public void updateAverage() {
        this.averageInsertion = (int)Math.round((double)this.averageInsertion * 0.5 + (double)this.tickInsert * 0.5);
        this.averageExtraction = (int)Math.round((double)this.averageExtraction * 0.5 + (double)this.tickExtract * 0.5);
        this.tickExtract = 0;
        this.tickInsert = 0;
    }

    public int receiveEnergy(int energy, boolean simulate) {
        int received = super.receiveEnergy(energy, simulate);
        if (!simulate) {
            this.tickInsert += energy;
        }
        return received;
    }

    public int extractEnergy(int energy, boolean simulate) {
        int extracted = super.extractEnergy(energy, simulate);
        if (!simulate) {
            this.tickExtract += energy;
        }
        return extracted;
    }

    public int getAverageInsertion() {
        return this.averageInsertion;
    }

    public int getAverageExtraction() {
        return this.averageExtraction;
    }
}

