/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event.timed;

import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.SoundRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;

public class BuildPortalEvent
implements ITimedEvent {
    Level level;
    BlockPos targetPos;
    Direction direction;
    List<BlockPos> framePos = new ArrayList<BlockPos>();
    List<BlockPos> portalPos = new ArrayList<BlockPos>();
    int ticks;
    List<BlockPos> placedBlocks = new ArrayList<BlockPos>();

    public BuildPortalEvent(Level level, BlockPos targetPos, Direction direction) {
        this.level = level;
        this.targetPos = targetPos;
        this.direction = direction;
        this.ticks = 1;
        BlockPos aboveTarget = targetPos.m_7494_();
        int width = 2;
        BlockPos leftBotTarget = aboveTarget.m_7918_(width * direction.m_122429_(), 0, width * direction.m_122431_());
        BlockPos rightBotTarget = aboveTarget.m_7918_(width * -direction.m_122429_(), 0, width * -direction.m_122431_());
        for (BlockPos pos1 : BlockPos.m_121940_((BlockPos)leftBotTarget, (BlockPos)rightBotTarget)) {
            this.framePos.add(pos1.m_7949_());
        }
        for (BlockPos pos1 : BlockPos.m_121940_((BlockPos)rightBotTarget.m_7494_(), (BlockPos)rightBotTarget.m_6630_(3))) {
            this.framePos.add(pos1.m_7949_());
        }
        for (BlockPos pos1 : BlockPos.m_121940_((BlockPos)leftBotTarget.m_6630_(4), (BlockPos)rightBotTarget.m_6630_(4))) {
            this.framePos.add(pos1.m_7949_());
        }
        for (BlockPos pos1 : BlockPos.m_121940_((BlockPos)leftBotTarget.m_7494_(), (BlockPos)leftBotTarget.m_6630_(3))) {
            this.framePos.add(pos1.m_7949_());
        }
        BlockPos leftPortalOffset = aboveTarget.m_7918_(direction.m_122429_(), 1, direction.m_122431_());
        BlockPos rightPortalOffset = aboveTarget.m_7918_(-direction.m_122429_(), 3, -direction.m_122431_());
        for (BlockPos pos1 : BlockPos.m_121940_((BlockPos)leftPortalOffset, (BlockPos)rightPortalOffset)) {
            this.portalPos.add(pos1.m_7949_());
        }
        Collections.shuffle(this.portalPos);
    }

    @Override
    public void tick(boolean serverSide) {
        boolean placingPortal;
        boolean placingFrame;
        ++this.ticks;
        if (this.ticks < 15) {
            return;
        }
        if (!serverSide || this.level.m_46467_() % 3L != 0L) {
            return;
        }
        boolean blocksPlaced = false;
        boolean destroyPortal = false;
        boolean bl = placingFrame = !this.framePos.isEmpty();
        if (placingFrame) {
            BlockPos pos = this.framePos.get(0);
            this.framePos.remove(pos);
            if (this.level.m_8055_(pos).m_60767_().m_76336_()) {
                this.level.m_7731_(pos, BlockRegistry.getBlock("sourcestone").m_49966_(), 3);
                this.level.m_5594_(null, pos, BlockRegistry.getBlock("sourcestone").m_49962_(this.level.m_8055_(pos)).m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtil.spawnTouchPacket(this.level, pos, ParticleColor.makeRandomColor(255, 255, 255, this.level.f_46441_).toWrapper());
                this.placedBlocks.add(pos);
                return;
            }
            destroyPortal = true;
        }
        boolean bl2 = placingPortal = !this.portalPos.isEmpty() && this.framePos.isEmpty() && !destroyPortal;
        if (placingPortal) {
            BlockPos pos = this.portalPos.get(0);
            this.portalPos.remove(pos);
            if (this.level.m_8055_(pos).m_60767_().m_76336_()) {
                this.level.m_7731_(pos, BlockRegistry.PORTAL_BLOCK.m_49966_(), 2);
                this.level.m_5594_(null, pos, BlockRegistry.PORTAL_BLOCK.m_49962_(this.level.m_8055_(pos)).m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.placedBlocks.add(pos);
            } else {
                destroyPortal = true;
            }
        }
        if (destroyPortal) {
            for (BlockPos pos : this.placedBlocks) {
                this.level.m_46961_(pos, false);
            }
            this.level.m_5594_(null, this.targetPos, SoundRegistry.GAIA_SPELL_SOUND.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.portalPos.clear();
            this.framePos.clear();
            return;
        }
        if (this.portalPos.isEmpty()) {
            this.level.m_5594_(null, this.targetPos.m_6630_(2), SoundRegistry.TEMPESTRY_SPELL_SOUND.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean isExpired() {
        return this.portalPos.isEmpty() && this.framePos.isEmpty();
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        return ITimedEvent.super.serialize(tag);
    }

    @Override
    public Void onPacketHandled() {
        return ITimedEvent.super.onPacketHandled();
    }

    @Override
    public String getID() {
        return ITimedEvent.super.getID();
    }
}

