/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.ExtendedRangeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StoreItemGoal
extends ExtendedRangeGoal {
    private final Starbuncle starbuncle;
    BlockPos storePos;
    boolean unreachable;
    StarbyTransportBehavior behavior;

    public StoreItemGoal(Starbuncle starbuncle, StarbyTransportBehavior transportBehavior) {
        super(25);
        this.starbuncle = starbuncle;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.behavior = transportBehavior;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.storePos = null;
        this.unreachable = false;
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.NONE;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.storePos = this.behavior.getValidStorePos(this.starbuncle.getHeldStack());
        if (this.storePos == null) {
            this.starbuncle.setBackOff(60 + this.starbuncle.f_19853_.f_46441_.m_188503_(60));
            return;
        }
        if (!this.starbuncle.getHeldStack().m_41619_()) {
            this.starbuncle.getNavigation().tryMoveToBlockPos(this.storePos, 1.3);
            this.startDistance = BlockUtil.distanceFrom(this.starbuncle.f_19825_, this.storePos);
        }
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.STORING_ITEM;
        this.starbuncle.addGoalDebug(this, new DebugEvent("StoreItemGoal", "Started storing item " + this.starbuncle.getHeldStack().m_41613_() + "x " + this.starbuncle.getHeldStack().m_41786_().getString() + " at " + this.storePos.toString()));
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (this.ticksRunning % 100 == 0 && this.behavior.isValidStorePos(this.storePos, this.starbuncle.getHeldStack()) != ItemScroll.SortPref.INVALID) {
            this.starbuncle.addDebugEvent(new DebugEvent("became_invalid", "Invalid store position " + this.storePos.toString()));
            this.storePos = null;
            return;
        }
        if (!this.starbuncle.getHeldStack().m_41619_() && this.storePos != null && BlockUtil.distanceFrom(this.starbuncle.m_20182_(), this.storePos) <= 2.0 + this.extendedRange) {
            this.starbuncle.getNavigation().m_26573_();
            Level world = this.starbuncle.f_19853_;
            BlockEntity tileEntity = world.m_7702_(this.storePos);
            if (tileEntity == null) {
                this.starbuncle.addGoalDebug(this, new DebugEvent("missing_tile", "store pos broken " + this.storePos.toString()));
                this.starbuncle.setBackOff(5 + this.starbuncle.f_19853_.f_46441_.m_188503_(20));
                return;
            }
            IItemHandler iItemHandler = (IItemHandler)tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
            if (iItemHandler != null) {
                ItemStack oldStack = new ItemStack((ItemLike)this.starbuncle.getHeldStack().m_41720_(), this.starbuncle.getHeldStack().m_41613_());
                ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)this.starbuncle.getHeldStack(), (boolean)false);
                if (left.equals(oldStack)) {
                    this.starbuncle.setBackOff(5 + this.starbuncle.f_19853_.f_46441_.m_188503_(20));
                    this.starbuncle.addGoalDebug(this, new DebugEvent("no_room", this.storePos.toString()));
                    return;
                }
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    try {
                        OpenChestEvent event = new OpenChestEvent(serverLevel, this.storePos, 20);
                        event.open();
                        EventQueue.getServerInstance().addEvent(event);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.starbuncle.setHeldStack(left);
                this.starbuncle.setBackOff(5 + this.starbuncle.f_19853_.f_46441_.m_188503_(20));
                this.starbuncle.addGoalDebug(this, new DebugEvent("stored_item", "successful at " + this.storePos.toString() + "set stack to " + left.m_41613_() + "x " + left.m_41786_().getString()));
                return;
            }
        }
        if (this.storePos != null && !this.starbuncle.getHeldStack().m_41619_()) {
            this.setPath(this.storePos.m_123341_(), this.storePos.m_123342_(), this.storePos.m_123343_(), 1.3);
            this.starbuncle.addGoalDebug(this, new DebugEvent("path_set", "path set to " + this.storePos.toString()));
        }
    }

    public void setPath(double x, double y, double z, double speedIn) {
        this.starbuncle.getNavigation().tryMoveToBlockPos(new BlockPos(x, y, z), 1.3);
        if (this.starbuncle.getNavigation().m_26570_() != null && !this.starbuncle.getNavigation().m_26570_().m_77403_()) {
            this.unreachable = true;
            this.starbuncle.addGoalDebug(this, new DebugEvent("unreachable", this.storePos.toString()));
        }
    }

    public boolean m_8045_() {
        return !this.unreachable && !this.starbuncle.getHeldStack().m_41619_() && this.starbuncle.getBackOff() == 0 && this.storePos != null;
    }

    @Override
    public boolean m_8036_() {
        return !this.starbuncle.getHeldStack().m_41619_() && this.starbuncle.getBackOff() == 0;
    }
}

