/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.common.entity.IFollowingSummon;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.goal.FollowSummonerGoal;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class SummonSkeleton
extends Skeleton
implements IFollowingSummon,
ISummon {
    private final RangedBowAttackGoal<SummonSkeleton> bowGoal = new RangedBowAttackGoal((Monster)this, 1.0, 20, 15.0f);
    private final MeleeAttackGoal meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 2.2, true){

        public void m_8041_() {
            super.m_8041_();
            SummonSkeleton.this.m_21561_(false);
        }

        public void m_8056_() {
            super.m_8056_();
            SummonSkeleton.this.m_21561_(true);
        }
    };
    private LivingEntity owner;
    @Nullable
    private BlockPos boundOrigin;
    private boolean limitedLifespan;
    private int limitedLifeTicks;

    public SummonSkeleton(EntityType<? extends Skeleton> entityType, Level level) {
        super(entityType, level);
    }

    public SummonSkeleton(Level level, LivingEntity owner, ItemStack item) {
        super((EntityType)ModEntities.SUMMON_SKELETON.get(), level);
        this.setWeapon(item);
        this.owner = owner;
        this.limitedLifespan = true;
        this.setOwnerID(owner.m_20148_());
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.SUMMON_SKELETON.get();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.m_213945_(this.m_217043_(), difficultyIn);
        this.m_213946_(this.m_217043_(), difficultyIn);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance pDifficulty) {
    }

    protected void m_6668_(DamageSource pDamageSource) {
    }

    protected boolean m_6125_() {
        return false;
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
    }

    protected void m_5907_() {
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new FollowSummonerGoal(this, this.owner, 1.0, 9.0f, 3.0f));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new CopyOwnerTargetGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, false, true, entity -> {
            Mob mob;
            return entity instanceof Mob && (mob = (Mob)entity).m_5448_() != null && mob.m_5448_().equals((Object)this.owner) || entity != null && entity.m_21232_() != null && entity.m_21232_().equals((Object)this.owner);
        }));
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    public void setWeapon(ItemStack item) {
        this.m_8061_(EquipmentSlot.MAINHAND, item);
        this.m_32164_();
    }

    public void m_32164_() {
        if (this.f_19853_ instanceof ServerLevel && this.m_21120_(InteractionHand.MAIN_HAND) != ItemStack.f_41583_) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_(this.bowGoal);
            ItemStack itemstack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            if (itemstack.m_150930_(Items.f_42411_)) {
                this.bowGoal.m_25797_(20);
                this.f_21345_.m_25352_(4, this.bowGoal);
            } else {
                this.f_21345_.m_25352_(4, (Goal)this.meleeGoal);
            }
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        ISummon summon;
        EntityDamageSource eSource;
        Entity entity;
        if (pSource instanceof EntityDamageSource && (entity = (eSource = (EntityDamageSource)pSource).m_7639_()) instanceof ISummon && (summon = (ISummon)entity).getOwnerID() != null && summon.getOwnerID().equals(this.getOwnerID())) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (--this.limitedLifeTicks <= 0) {
            this.limitedLifeTicks = 20;
            this.m_6469_(DamageSource.f_19313_, 20.0f);
        }
    }

    @Override
    public Level getWorld() {
        return this.f_19853_;
    }

    @Override
    public PathNavigation getPathNav() {
        return this.f_21344_;
    }

    @Override
    public Mob getSelfEntity() {
        return this;
    }

    @Override
    public LivingEntity getSummoner() {
        return this.getOwnerFromID();
    }

    public LivingEntity getActualOwner() {
        return this.owner;
    }

    public int m_213860_() {
        return 0;
    }

    public void m_7378_(CompoundTag compound) {
        UUID s;
        super.m_7378_(compound);
        if (compound.m_128441_("BoundX")) {
            this.boundOrigin = new BlockPos(compound.m_128451_("BoundX"), compound.m_128451_("BoundY"), compound.m_128451_("BoundZ"));
        }
        if (compound.m_128441_("LifeTicks")) {
            this.setLimitedLife(compound.m_128451_("LifeTicks"));
        }
        if (compound.m_128425_("OwnerUUID", 8)) {
            s = compound.m_128342_("OwnerUUID");
        } else {
            String s1 = compound.m_128461_("Owner");
            s = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s1);
        }
        if (s != null) {
            try {
                this.setOwnerID(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setLimitedLife(int lifeTicks) {
        this.limitedLifeTicks = lifeTicks;
    }

    public LivingEntity getOwnerFromID() {
        try {
            UUID uuid = this.getOwnerID();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.boundOrigin != null) {
            compound.m_128405_("BoundX", this.boundOrigin.m_123341_());
            compound.m_128405_("BoundY", this.boundOrigin.m_123342_());
            compound.m_128405_("BoundZ", this.boundOrigin.m_123343_());
        }
        if (this.limitedLifespan) {
            compound.m_128405_("LifeTicks", this.limitedLifeTicks);
        }
        if (this.getOwnerID() == null) {
            compound.m_128362_("OwnerUUID", Util.f_137441_);
        } else {
            compound.m_128362_("OwnerUUID", this.getOwnerID());
        }
    }

    protected boolean m_21527_() {
        return false;
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        this.onSummonDeath(this.f_19853_, cause, false);
    }

    @Override
    public int getTicksLeft() {
        return this.limitedLifeTicks;
    }

    @Override
    public void setTicksLeft(int ticks) {
        this.limitedLifeTicks = ticks;
    }

    @Override
    @Nullable
    public UUID getOwnerID() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    @Override
    public void setOwnerID(UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    class CopyOwnerTargetGoal
    extends TargetGoal {
        public CopyOwnerTargetGoal(PathfinderMob creature) {
            super((Mob)creature, false);
        }

        public boolean m_8036_() {
            return SummonSkeleton.this.owner != null && SummonSkeleton.this.owner.m_21214_() != null;
        }

        public void m_8056_() {
            SummonSkeleton.this.m_6710_(SummonSkeleton.this.owner.m_21214_());
            super.m_8056_();
        }
    }
}

