/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.spell.ILightable;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.block.SconceBlock;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class ArchfruitPod
extends HorizontalDirectionalBlock
implements BonemealableBlock,
ILightable {
    public Supplier<Block> surviveBlock;
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    protected static final VoxelShape[] EAST_AABB = new VoxelShape[]{Block.m_49796_((double)11.0, (double)7.0, (double)6.0, (double)15.0, (double)11.0, (double)10.0), Block.m_49796_((double)9.0, (double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), Block.m_49796_((double)7.0, (double)3.0, (double)4.0, (double)15.0, (double)11.0, (double)12.0)};
    protected static final VoxelShape[] NORTH_AABB = new VoxelShape[]{Block.m_49796_((double)6.0, (double)7.0, (double)1.0, (double)10.0, (double)11.0, (double)5.0), Block.m_49796_((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)7.0), Block.m_49796_((double)4.0, (double)3.0, (double)1.0, (double)12.0, (double)11.0, (double)9.0)};
    protected static final VoxelShape[] SOUTH_AABB = new VoxelShape[]{Block.m_49796_((double)6.0, (double)7.0, (double)11.0, (double)10.0, (double)11.0, (double)15.0), Block.m_49796_((double)5.0, (double)5.0, (double)9.0, (double)11.0, (double)11.0, (double)15.0), Block.m_49796_((double)4.0, (double)3.0, (double)7.0, (double)12.0, (double)11.0, (double)15.0)};
    protected static final VoxelShape[] WEST_AABB = new VoxelShape[]{Block.m_49796_((double)1.0, (double)7.0, (double)6.0, (double)5.0, (double)11.0, (double)10.0), Block.m_49796_((double)1.0, (double)5.0, (double)5.0, (double)7.0, (double)11.0, (double)11.0), Block.m_49796_((double)1.0, (double)3.0, (double)4.0, (double)9.0, (double)11.0, (double)12.0)};

    public ArchfruitPod(Supplier<Block> surviveBlock) {
        this(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60977_().m_60913_(0.2f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60953_(b -> (Integer)b.m_61143_(SconceBlock.LIGHT_LEVEL)));
        this.surviveBlock = surviveBlock;
    }

    public ArchfruitPod(BlockBehaviour.Properties p_51743_) {
        super(p_51743_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_(SconceBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_6724_(BlockState pState) {
        return (Integer)pState.m_61143_((Property)AGE) < 2;
    }

    public void m_213898_(BlockState p_221000_, ServerLevel p_221001_, BlockPos p_221002_, RandomSource p_221003_) {
        int i = (Integer)p_221000_.m_61143_((Property)AGE);
        if (i < 2 && ForgeHooks.onCropsGrowPre((Level)p_221001_, (BlockPos)p_221002_, (BlockState)p_221000_, (p_221001_.f_46441_.m_188503_(5) == 0 ? 1 : 0) != 0)) {
            p_221001_.m_7731_(p_221002_, (BlockState)p_221000_.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)p_221001_, (BlockPos)p_221002_, (BlockState)p_221000_);
        }
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.m_8055_(pPos.m_121945_((Direction)pState.m_61143_((Property)f_54117_)));
        return blockstate.m_60734_() == this.surviveBlock.get();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int i = (Integer)pState.m_61143_((Property)AGE);
        switch ((Direction)pState.m_61143_((Property)f_54117_)) {
            case SOUTH: {
                return SOUTH_AABB[i];
            }
            case WEST: {
                return WEST_AABB[i];
            }
            case EAST: {
                return EAST_AABB[i];
            }
        }
        return NORTH_AABB[i];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate = this.m_49966_();
        Level levelreader = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        for (Direction direction : pContext.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(blockstate = (BlockState)blockstate.m_61124_((Property)f_54117_, (Comparable)direction)).m_60710_((LevelReader)levelreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing == pState.m_61143_((Property)f_54117_) && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean m_7370_(BlockGetter pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return (Integer)pState.m_61143_((Property)AGE) < 2;
    }

    public boolean m_214167_(Level p_220995_, RandomSource p_220996_, BlockPos p_220997_, BlockState p_220998_) {
        return true;
    }

    public void m_214148_(ServerLevel p_220990_, RandomSource p_220991_, BlockPos p_220992_, BlockState p_220993_) {
        p_220990_.m_7731_(p_220992_, (BlockState)p_220993_.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)p_220993_.m_61143_((Property)AGE) + 1)), 2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_, AGE, SconceBlock.LIGHT_LEVEL});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Override
    public void onLight(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats stats, SpellContext spellContext) {
        if (rayTraceResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
            BlockState state = world.m_8055_(blockHitResult.m_82425_());
            world.m_7731_(blockHitResult.m_82425_(), (BlockState)state.m_61124_(SconceBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(Math.min(Math.max(0, 8 - stats.getBuffCount(AugmentDampen.INSTANCE)), 8))), 3);
            world.m_7260_(blockHitResult.m_82425_(), state, (BlockState)state.m_61124_(SconceBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(Math.min(Math.max(0, 8 - stats.getBuffCount(AugmentDampen.INSTANCE)), 8))), 3);
        }
    }
}

