/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.perk.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.block.TableBlock;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.block.tile.AlterationTile;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AlterationTable
extends TableBlock {
    public static VoxelShape SOUTH_OTHER = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.4, (double)0.0, (double)1.0, (double)7.333333, (double)1.0, (double)17.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.333333, (double)0.0, (double)1.0, (double)12.666667, (double)4.5, (double)17.0), Block.m_49796_((double)12.666667, (double)4.0, (double)1.0, (double)14.0, (double)10.0, (double)17.0)});
    public static VoxelShape NORTH_OTHER = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)8.666667, (double)0.0, (double)-1.0, (double)12.6, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)3.333333, (double)0.0, (double)-1.0, (double)8.666667, (double)4.5, (double)15.0), Block.m_49796_((double)2.0, (double)4.0, (double)-1.0, (double)3.333333, (double)10.0, (double)15.0)});
    public static VoxelShape EAST_OTHER = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)8.666667, (double)17.0, (double)1.0, (double)12.6), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)3.333333, (double)17.0, (double)4.5, (double)8.666667), Block.m_49796_((double)1.0, (double)4.0, (double)2.0, (double)17.0, (double)10.0, (double)3.333333)});
    public static VoxelShape WEST_OTHER = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-1.0, (double)0.0, (double)3.4, (double)15.0, (double)1.0, (double)7.333333), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-1.0, (double)0.0, (double)7.333333, (double)15.0, (double)4.5, (double)12.666667), Block.m_49796_((double)-1.0, (double)4.0, (double)12.666667, (double)15.0, (double)10.0, (double)14.0)});

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (world.f_46443_ || handIn != InteractionHand.MAIN_HAND || !((blockEntity = world.m_7702_(pos)) instanceof AlterationTile)) {
            return InteractionResult.SUCCESS;
        }
        AlterationTile tile = (AlterationTile)blockEntity;
        ItemStack stack = player.m_21205_();
        if (tile.isMasterTile()) {
            IPerkHolder<ItemStack> holder = PerkUtil.getPerkHolder(stack);
            if (holder instanceof ArmorPerkHolder) {
                if (tile.armorStack.m_41619_()) {
                    tile.setArmorStack(stack, player);
                    return InteractionResult.SUCCESS;
                }
            } else if (stack.m_41619_() && !tile.armorStack.m_41619_()) {
                tile.removeArmorStack(player);
                return InteractionResult.SUCCESS;
            }
        } else if (state.m_61143_((Property)PART) == ThreePartBlock.OTHER) {
            this.m_6227_(world.m_8055_(pos.m_7495_()), world, pos.m_7495_(), player, handIn, hit);
        } else {
            if ((tile = tile.getLogicTile()) == null) {
                return InteractionResult.SUCCESS;
            }
            if (stack.m_41619_()) {
                tile.removePerk(player);
                return InteractionResult.SUCCESS;
            }
            if (!(stack.m_41720_() instanceof PerkItem)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.perk.not_perk"));
                return InteractionResult.SUCCESS;
            }
            tile.addPerkStack(stack, player);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new AlterationTile(pPos, pState);
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(worldIn, pos, state, player);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof AlterationTile) {
            AlterationTile tile = (AlterationTile)blockEntity;
            tile.dropItems();
        }
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        ThreePartBlock partBlock = (ThreePartBlock)((Object)state.m_61143_((Property)PART));
        if (partBlock != ThreePartBlock.OTHER) {
            return super.m_5940_(state, getter, pos, context);
        }
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (direction == Direction.SOUTH) {
            return SOUTH_OTHER;
        }
        if (direction == Direction.NORTH) {
            return NORTH_OTHER;
        }
        if (direction == Direction.EAST) {
            return EAST_OTHER;
        }
        if (direction == Direction.WEST) {
            return WEST_OTHER;
        }
        return super.m_5940_(state, getter, pos, context);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        ThreePartBlock partBlock = (ThreePartBlock)((Object)pState.m_61143_((Property)PART));
        if (partBlock != ThreePartBlock.OTHER) {
            return super.m_5939_(pState, pLevel, pPos, pContext);
        }
        return Shapes.m_83040_();
    }

    @Override
    public BlockState tearDown(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        BlockEntity entity;
        if (!world.m_5776_() && (entity = world.m_7702_(pos)) instanceof AlterationTile) {
            AlterationTile tile = (AlterationTile)entity;
            tile.dropItems();
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity entity, ItemStack stack) {
        if (world.f_46443_) {
            return;
        }
        BlockPos blockpos = pos.m_121945_((Direction)state.m_61143_((Property)FACING));
        world.m_7731_(blockpos, (BlockState)state.m_61124_((Property)PART, (Comparable)((Object)ThreePartBlock.HEAD)), 3);
        BlockPos lecternPos = pos.m_121945_(Direction.UP);
        world.m_7731_(lecternPos, (BlockState)state.m_61124_((Property)PART, (Comparable)((Object)ThreePartBlock.OTHER)), 3);
        world.m_6289_(pos, Blocks.f_50016_);
        state.m_60701_((LevelAccessor)world, pos, 3);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        List<Direction> connectedDirs = this.getConnectedDirections(state);
        if (connectedDirs.contains(direction)) {
            for (Direction dir : connectedDirs) {
                if (world.m_8055_(pos.m_121945_(dir)).m_60734_() == this) continue;
                return this.tearDown(state, dir, state2, world, pos, pos2);
            }
        }
        return super.m_7417_(state, direction, state2, world, pos, pos2);
    }

    public List<Direction> getConnectedDirections(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return switch ((ThreePartBlock)((Object)state.m_61143_((Property)PART))) {
            case ThreePartBlock.HEAD -> List.of(direction.m_122424_());
            case ThreePartBlock.FOOT -> List.of(direction, Direction.UP);
            case ThreePartBlock.OTHER -> List.of(Direction.DOWN);
            default -> List.of();
        };
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        BlockState horizontalState = context.m_43725_().m_8055_(blockpos1);
        BlockState aboveState = context.m_43725_().m_8055_(blockpos.m_7494_());
        return horizontalState.m_60629_(context) && aboveState.m_60629_(context) ? (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction) : null;
    }
}

