/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.common.entity.WildenGuardian;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.ars_nouveau.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.ars_nouveau.geckolib3.core.processor.IBone;
import software.bernie.ars_nouveau.geckolib3.model.AnimatedGeoModel;
import software.bernie.ars_nouveau.geckolib3.model.provider.data.EntityModelData;

public class WildenGuardianModel
extends AnimatedGeoModel<WildenGuardian> {
    public static final ResourceLocation WARDER_NEUTRAL = new ResourceLocation("ars_nouveau", "geo/wilden_warder_neutral.geo.json");
    public static final ResourceLocation WARDER_ARMORED = new ResourceLocation("ars_nouveau", "geo/wilden_warder_defense.geo.json");
    public static final ResourceLocation TEXT = new ResourceLocation("ars_nouveau", "textures/entity/warder.png");
    public static final ResourceLocation ANIM = new ResourceLocation("ars_nouveau", "animations/wilden_warder_animation_neutral.geo.json");

    @Override
    public void setCustomAnimations(WildenGuardian entity, int uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setCustomAnimations(entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
        head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        IBone frontLeftLeg = this.getAnimationProcessor().getBone("left_leg");
        IBone frontRightLeg = this.getAnimationProcessor().getBone("right_leg");
        frontLeftLeg.setRotationX(Mth.m_14089_((float)(entity.f_20925_ * 0.6662f)) * 1.4f * entity.f_20924_);
        frontRightLeg.setRotationX(Mth.m_14089_((float)(entity.f_20925_ * 0.6662f + (float)Math.PI)) * 1.4f * entity.f_20924_);
    }

    @Override
    public ResourceLocation getModelResource(WildenGuardian wildenStalker) {
        return wildenStalker.isArmored() ? WARDER_ARMORED : WARDER_NEUTRAL;
    }

    @Override
    public ResourceLocation getTextureResource(WildenGuardian wildenStalker) {
        return TEXT;
    }

    @Override
    public ResourceLocation getAnimationResource(WildenGuardian wildenStalker) {
        return ANIM;
    }
}

