/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.event.SummonEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.IInventoryResponder;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.LootUtil;
import com.hollingsworth.arsnouveau.common.items.VoidJar;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEffect
extends AbstractSpellPart {
    public ForgeConfigSpec.DoubleValue DAMAGE;
    public ForgeConfigSpec.DoubleValue AMP_VALUE;
    public ForgeConfigSpec.IntValue POTION_TIME;
    public ForgeConfigSpec.IntValue EXTEND_TIME;
    public ForgeConfigSpec.IntValue GENERIC_INT;
    public ForgeConfigSpec.DoubleValue GENERIC_DOUBLE;

    public AbstractEffect(String tag, String description) {
        super(tag, description);
    }

    public AbstractEffect(ResourceLocation tag, String description) {
        super(tag, description);
    }

    @Override
    public Integer getTypeIndex() {
        return 10;
    }

    public void onResolve(HitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (rayTraceResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
            this.onResolveBlock(blockHitResult, world, shooter, spellStats, spellContext, resolver);
        } else if (rayTraceResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)rayTraceResult;
            this.onResolveEntity(entityHitResult, world, shooter, spellStats, spellContext, resolver);
        }
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
    }

    @Deprecated(forRemoval=true)
    public void applyConfigPotion(LivingEntity entity, MobEffect potionEffect, SpellStats spellStats) {
        this.applyConfigPotion(entity, potionEffect, spellStats, true);
    }

    @Deprecated(forRemoval=true)
    public void applyConfigPotion(LivingEntity entity, MobEffect potionEffect, SpellStats spellStats, boolean showParticles) {
        this.applyPotion(entity, potionEffect, spellStats, this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get(), this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get(), showParticles);
    }

    @Deprecated(forRemoval=true)
    public void applyPotion(LivingEntity entity, MobEffect potionEffect, SpellStats stats, int baseDurationSeconds, int durationBuffSeconds, boolean showParticles) {
        if (entity == null) {
            return;
        }
        int ticks = baseDurationSeconds * 20 + durationBuffSeconds * stats.getDurationInTicks();
        int amp = (int)stats.getAmpMultiplier();
        entity.m_7292_(new MobEffectInstance(potionEffect, ticks, amp, false, showParticles, true));
    }

    public boolean canSummon(LivingEntity playerEntity) {
        Player player;
        return this.isRealPlayer((Entity)playerEntity) && (playerEntity.m_21124_((MobEffect)ModPotions.SUMMONING_SICKNESS_EFFECT.get()) == null || playerEntity instanceof Player && (player = (Player)playerEntity).m_7500_());
    }

    public void applySummoningSickness(LivingEntity playerEntity, int time) {
        playerEntity.m_7292_(new MobEffectInstance((MobEffect)ModPotions.SUMMONING_SICKNESS_EFFECT.get(), time));
    }

    public void summonLivingEntity(HitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats augments, SpellContext spellContext, ISummon summon) {
        if (this.isRealPlayer((Entity)shooter)) {
            summon.setOwnerID(shooter.m_20148_());
        }
        if (summon.getLivingEntity() != null) {
            world.m_7967_((Entity)summon.getLivingEntity());
        }
        MinecraftForge.EVENT_BUS.post((Event)new SummonEvent(rayTraceResult, world, shooter, augments, spellContext, summon));
    }

    public Player getPlayer(LivingEntity entity, ServerLevel world) {
        ANFakePlayer aNFakePlayer;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            aNFakePlayer = player;
        } else {
            aNFakePlayer = ANFakePlayer.getPlayer(world);
        }
        return aNFakePlayer;
    }

    public int getBaseHarvestLevel(SpellStats stats) {
        return (int)(3.0 + stats.getAmpMultiplier());
    }

    public boolean canBlockBeHarvested(SpellStats stats, Level world, BlockPos pos) {
        return BlockUtil.canBlockBeHarvested(stats, world, pos);
    }

    @Deprecated(forRemoval=true)
    public void dealDamage(Level world, @NotNull LivingEntity shooter, float baseDamage, SpellStats stats, Entity entity, DamageSource source) {
        LivingEntity mob;
        ServerLevel server;
        block9: {
            block8: {
                LivingEntity living;
                if (!(world instanceof ServerLevel)) break block8;
                server = (ServerLevel)world;
                if (!(entity instanceof LivingEntity) || !((living = (LivingEntity)entity).m_21223_() <= 0.0f)) break block9;
            }
            return;
        }
        float totalDamage = (float)((double)baseDamage + stats.getDamageModifier());
        SpellDamageEvent.Pre preDamage = new SpellDamageEvent.Pre(source, shooter, entity, totalDamage, null);
        MinecraftForge.EVENT_BUS.post((Event)preDamage);
        source = preDamage.damageSource;
        totalDamage = preDamage.damage;
        if (totalDamage <= 0.0f || preDamage.isCanceled()) {
            return;
        }
        if (!entity.m_6469_(source, totalDamage)) {
            return;
        }
        SpellDamageEvent.Post postDamage = new SpellDamageEvent.Post(source, shooter, entity, totalDamage, null);
        MinecraftForge.EVENT_BUS.post((Event)postDamage);
        if (entity instanceof LivingEntity && (mob = (LivingEntity)entity).m_21223_() <= 0.0f && !mob.m_213877_() && stats.hasBuff(AugmentFortune.INSTANCE)) {
            ANFakePlayer aNFakePlayer;
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                aNFakePlayer = player;
            } else {
                aNFakePlayer = ANFakePlayer.getPlayer(server);
            }
            ANFakePlayer playerContext = aNFakePlayer;
            int looting = stats.getBuffCount(AugmentFortune.INSTANCE);
            LootContext.Builder lootContext = LootUtil.getLootingContext(server, shooter, mob, looting, DamageSource.m_19344_((Player)playerContext));
            ResourceLocation lootTable = mob.m_5743_();
            LootTable loottable = server.m_7654_().m_129898_().m_79217_(lootTable);
            ObjectArrayList items = loottable.m_230922_(lootContext.m_78975_(LootContextParamSets.f_81415_));
            items.forEach(arg_0 -> ((LivingEntity)mob).m_19983_(arg_0));
        }
    }

    public Vec3 safelyGetHitPos(HitResult result) {
        Vec3 vec3;
        if (result instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)result;
            vec3 = entityHitResult.m_82443_().m_20182_();
        } else {
            vec3 = result.m_82450_();
        }
        return vec3;
    }

    public boolean isRealPlayer(Entity entity) {
        return entity instanceof Player && this.isNotFakePlayer(entity);
    }

    public boolean isNotFakePlayer(Entity entity) {
        return !(entity instanceof FakePlayer);
    }

    public void applyEnchantments(SpellStats stats, ItemStack stack) {
        if (stats.hasBuff(AugmentExtract.INSTANCE)) {
            stack.m_41663_(Enchantments.f_44985_, 1);
        }
        if (stats.hasBuff(AugmentFortune.INSTANCE)) {
            stack.m_41663_(Enchantments.f_44987_, stats.getBuffCount(AugmentFortune.INSTANCE));
        }
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        super.buildAugmentLimitsConfig(builder, this.getDefaultAugmentLimits(new HashMap<ResourceLocation, Integer>()));
    }

    public void addDamageConfig(ForgeConfigSpec.Builder builder, double defaultValue) {
        this.DAMAGE = builder.defineInRange("damage", defaultValue, 0.0, 2.147483647E9);
    }

    public void addAmpConfig(ForgeConfigSpec.Builder builder, double defaultValue) {
        this.AMP_VALUE = builder.defineInRange("amplify", defaultValue, 0.0, 2.147483647E9);
    }

    public void addPotionConfig(ForgeConfigSpec.Builder builder, int defaultTime) {
        this.POTION_TIME = builder.comment("Potion duration, in seconds").defineInRange("potion_time", defaultTime, 0, Integer.MAX_VALUE);
    }

    public void addExtendTimeConfig(ForgeConfigSpec.Builder builder, int defaultTime) {
        this.EXTEND_TIME = builder.comment("Extend time duration, in seconds").defineInRange("extend_time", defaultTime, 0, Integer.MAX_VALUE);
    }

    public void addGenericInt(ForgeConfigSpec.Builder builder, int val, String comment, String path) {
        this.GENERIC_INT = builder.comment(comment).defineInRange(path, val, 0, Integer.MAX_VALUE);
    }

    public void addGenericDouble(ForgeConfigSpec.Builder builder, double val, String comment, String path) {
        this.GENERIC_DOUBLE = builder.comment(comment).defineInRange(path, val, 0.0, Double.MAX_VALUE);
    }

    public void addDefaultPotionConfig(ForgeConfigSpec.Builder builder) {
        this.addPotionConfig(builder, 30);
        this.addExtendTimeConfig(builder, 8);
    }

    @Deprecated(forRemoval=true, since="3.4.0")
    public ItemStack getItemFromCaster(@NotNull LivingEntity shooter, SpellContext spellContext, Predicate<ItemStack> predicate) {
        BlockEntity blockEntity = spellContext.castingTile;
        if (blockEntity instanceof IInventoryResponder) {
            IInventoryResponder iInventoryResponder = (IInventoryResponder)blockEntity;
            return iInventoryResponder.getItem(predicate);
        }
        if (shooter instanceof IInventoryResponder) {
            IInventoryResponder responder = (IInventoryResponder)shooter;
            return responder.getItem(predicate);
        }
        if (shooter instanceof Player) {
            Player playerEntity = (Player)shooter;
            NonNullList list = playerEntity.f_36093_.f_35974_;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = (ItemStack)list.get(i);
                if (!predicate.test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    @Deprecated(forRemoval=true, since="3.4.0")
    public ItemStack getItemFromCaster(@NotNull LivingEntity shooter, SpellContext spellContext, Item item) {
        return this.getItemFromCaster(shooter, spellContext, (ItemStack i) -> i.m_41656_(new ItemStack((ItemLike)item)));
    }

    @Deprecated(forRemoval=true, since="3.4.0")
    public ItemStack extractStackFromCaster(@NotNull LivingEntity shooter, SpellContext spellContext, Predicate<ItemStack> predicate, int maxExtract) {
        IInventoryResponder responder = null;
        if (spellContext.castingTile instanceof IInventoryResponder) {
            responder = (IInventoryResponder)spellContext.castingTile;
        } else if (shooter instanceof IInventoryResponder) {
            responder = (IInventoryResponder)shooter;
        }
        if (responder != null) {
            return responder.extractItem(predicate, maxExtract);
        }
        if (shooter instanceof Player) {
            Player playerEntity = (Player)shooter;
            NonNullList list = playerEntity.f_36093_.f_35974_;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = (ItemStack)list.get(i);
                if (!predicate.test(stack)) continue;
                return stack.m_41620_(maxExtract);
            }
        }
        return ItemStack.f_41583_;
    }

    @Deprecated(forRemoval=true, since="3.4.0")
    public ItemStack insertStackToCaster(@NotNull LivingEntity shooter, SpellContext spellContext, ItemStack stack) {
        IPickupResponder responder = null;
        if (spellContext.castingTile instanceof IPickupResponder) {
            responder = (IPickupResponder)spellContext.castingTile;
        } else if (shooter instanceof IInventoryResponder) {
            responder = (IPickupResponder)shooter;
        }
        if (responder != null) {
            return responder.onPickup(stack);
        }
        if (this.isRealPlayer((Entity)shooter)) {
            Player player = (Player)shooter;
            VoidJar.tryVoiding(player, stack);
            if (!player.m_36356_(stack)) {
                ItemEntity i = new ItemEntity(shooter.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                shooter.f_19853_.m_7967_((Entity)i);
            }
        }
        return stack;
    }

    protected Set<AbstractAugment> getPotionAugments() {
        return this.augmentSetOf(AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAmplify.INSTANCE);
    }

    protected Set<AbstractAugment> getSummonAugments() {
        return this.augmentSetOf(AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE);
    }
}

