/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.EnderDrawerTile;
import com.buuz135.functionalstorage.client.DrawerRenderer;
import com.buuz135.functionalstorage.client.FunctionalStorageClientConfig;
import com.buuz135.functionalstorage.inventory.EnderInventoryHandler;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.util.MathUtils;
import com.buuz135.functionalstorage.world.EnderSavedData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;

public class EnderDrawerRenderer
implements BlockEntityRenderer<EnderDrawerTile> {
    public void render(EnderDrawerTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (Minecraft.m_91087_().f_91074_ != null && !tile.m_58899_().m_123314_((Vec3i)Minecraft.m_91087_().f_91074_.m_20097_(), (double)FunctionalStorageClientConfig.DRAWER_RENDER_RANGE)) {
            return;
        }
        matrixStack.m_85836_();
        Direction facing = tile.getFacingDirection();
        matrixStack.m_166854_(MathUtils.createTransformMatrix(Vector3f.f_176763_, new Vector3f(0.0f, 180.0f, 0.0f), 1.0f));
        if (facing == Direction.NORTH) {
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(-1.0f, 0.0f, 0.0f), Vector3f.f_176763_, 1.0f));
        } else if (facing == Direction.EAST) {
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(0.0f, -90.0f, 0.0f), 1.0f));
        } else if (facing == Direction.SOUTH) {
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 180.0f, 0.0f), 1.0f));
        } else if (facing == Direction.WEST) {
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 90.0f, 0.0f), 1.0f));
        }
        matrixStack.m_85837_(0.0, 0.0, -0.03125);
        combinedLightIn = LevelRenderer.m_109541_((BlockAndTintGetter)tile.m_58904_(), (BlockPos)tile.m_58899_().m_121945_(facing));
        EnderDrawerRenderer.renderUpgrades(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        this.render1Slot(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        matrixStack.m_85849_();
    }

    public static void renderUpgrades(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, ControllableDrawerTile<?> tile) {
        float scale = 0.0625f;
        if (tile.getDrawerOptions().isActive(ConfigurationToolItem.ConfigurationAction.TOGGLE_UPGRADES)) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.031, (double)0.031f, 0.0295);
            for (int i = 0; i < tile.getStorageUpgrades().getSlots(); ++i) {
                ItemStack stack = tile.getStorageUpgrades().getStackInSlot(i);
                if (stack.m_41619_()) continue;
                matrixStack.m_85836_();
                matrixStack.m_85841_(scale, scale, scale);
                Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.NONE, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
                matrixStack.m_85849_();
                matrixStack.m_85837_((double)scale, 0.0, 0.0);
            }
            matrixStack.m_85849_();
        }
        if (tile.isVoid()) {
            matrixStack.m_85836_();
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(0.969f, 0.031f, 0.0293125f), Vector3f.f_176763_, scale));
            Minecraft.m_91087_().m_91291_().m_174269_(new ItemStack((ItemLike)FunctionalStorage.VOID_UPGRADE.get()), ItemTransforms.TransformType.NONE, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
            matrixStack.m_85849_();
        }
    }

    private void render1Slot(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, EnderDrawerTile tile) {
        EnderInventoryHandler inventoryHandler = EnderSavedData.getInstance((LevelAccessor)tile.m_58904_()).getFrequency(tile.getFrequency());
        if (!inventoryHandler.getStoredStacks().get(0).getStack().m_41619_()) {
            matrixStack.m_85837_(0.5, 0.5, (double)5.0E-4f);
            ItemStack stack = inventoryHandler.getStoredStacks().get(0).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStoredStacks().get(0).getAmount(), 0.015f, tile.getDrawerOptions());
        }
    }
}

