/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.init.ModConfig;
import xyz.vsngamer.elevatorid.network.NetworkHandler;
import xyz.vsngamer.elevatorid.network.TeleportHandler;
import xyz.vsngamer.elevatorid.network.TeleportRequest;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="elevatorid")
public class ElevatorHandler {
    private static boolean lastSneaking;

    @SubscribeEvent
    public static void onInput(InputEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_5833_() || !player.m_6084_()) {
            return;
        }
        boolean sneaking = player.f_108618_.f_108573_;
        if (lastSneaking != sneaking) {
            lastSneaking = sneaking;
            if (sneaking) {
                ElevatorHandler.tryTeleport(player, Direction.DOWN);
            }
        }
    }

    @SubscribeEvent
    public static void jump(LivingEvent.LivingJumpEvent e) {
        if (e.getEntity() instanceof Player && e.getEntity().f_19853_.f_46443_) {
            ElevatorHandler.tryTeleport((LocalPlayer)e.getEntity(), Direction.UP);
        }
    }

    private static void tryTeleport(LocalPlayer player, Direction facing) {
        block2: {
            ElevatorBlock toElevator;
            Level world = player.m_20193_();
            BlockPos fromPos = ElevatorHandler.getOriginElevator(player);
            if (fromPos == null) {
                return;
            }
            BlockPos.MutableBlockPos toPos = fromPos.m_122032_();
            ElevatorBlock fromElevator = (ElevatorBlock)world.m_8055_(fromPos).m_60734_();
            do {
                toPos.m_142448_(toPos.m_123342_() + facing.m_122430_());
                if (world.m_151570_((BlockPos)toPos) || Math.abs(toPos.m_123342_() - fromPos.m_123342_()) > (Integer)ModConfig.GENERAL.range.get()) break block2;
            } while ((toElevator = TeleportHandler.getElevator(world.m_8055_((BlockPos)toPos))) == null || !TeleportHandler.isBlocked((BlockGetter)world, (BlockPos)toPos) || ((Boolean)ModConfig.GENERAL.sameColor.get()).booleanValue() && fromElevator.getColor() != toElevator.getColor());
            NetworkHandler.INSTANCE.sendToServer((Object)new TeleportRequest(fromPos, (BlockPos)toPos));
        }
    }

    private static BlockPos getOriginElevator(LocalPlayer player) {
        Level world = player.m_20193_();
        BlockPos pos = new BlockPos(player.m_20182_());
        for (int i = 0; i < 3; ++i) {
            if (TeleportHandler.getElevator(world.m_8055_(pos)) != null && TeleportHandler.isBlocked((BlockGetter)world, pos)) {
                return pos;
            }
            pos = pos.m_7495_();
        }
        return null;
    }
}

