/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.shaded.mixinextras.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;

public class ASMUtils {
    public static String annotationToString(AnnotationNode annotation) {
        StringBuilder builder = new StringBuilder("@").append(ASMUtils.typeToString(Type.getType((String)annotation.desc)));
        List values = annotation.values;
        if (values.isEmpty()) {
            return builder.toString();
        }
        builder.append('(');
        for (int i = 0; i < values.size(); i += 2) {
            if (i != 0) {
                builder.append(", ");
            }
            String name = (String)values.get(i);
            Object value = values.get(i + 1);
            builder.append(name).append(" = ").append(ASMUtils.valueToString(value));
        }
        builder.append(')');
        return builder.toString();
    }

    public static String typeToString(Type type) {
        String name = type.getClassName();
        return name.substring(name.lastIndexOf(46) + 1).replace('$', '.');
    }

    private static String valueToString(Object value) {
        if (value instanceof String) {
            return '\"' + value.toString() + '\"';
        }
        if (value instanceof Type) {
            Type type = (Type)value;
            return ASMUtils.typeToString(type) + ".class";
        }
        if (value instanceof String[]) {
            String[] enumInfo = (String[])value;
            return ASMUtils.typeToString(Type.getType((String)enumInfo[0])) + '.' + enumInfo[1];
        }
        if (value instanceof AnnotationNode) {
            return ASMUtils.annotationToString((AnnotationNode)value);
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() == 1) {
                return ASMUtils.valueToString(list.get(0));
            }
            return '{' + list.stream().map(ASMUtils::valueToString).collect(Collectors.joining(", ")) + '}';
        }
        return value.toString();
    }
}

