/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.registry;

import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.registry.CommandArgumentEntry;
import net.darkhax.bookshelf.api.registry.IGameRegistries;
import net.darkhax.bookshelf.api.registry.IRegistryEntries;
import net.darkhax.bookshelf.api.registry.IRegistryReader;
import net.darkhax.bookshelf.api.registry.RegistryDataProvider;
import net.darkhax.bookshelf.impl.registry.RegistryReaderForge;
import net.darkhax.bookshelf.impl.registry.RegistryReaderVanilla;
import net.darkhax.bookshelf.impl.util.ForgeEventHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

public class GameRegistriesForge
implements IGameRegistries {
    private final IRegistryReader<Block> blockRegistry = new RegistryReaderForge<Block>(ForgeRegistries.BLOCKS);
    private final IRegistryReader<Item> itemRegistry = new RegistryReaderForge<Item>(ForgeRegistries.ITEMS);
    private final IRegistryReader<BannerPattern> bannerPatternRegistry = new RegistryReaderVanilla<BannerPattern>(Registry.f_235736_);
    private final IRegistryReader<Enchantment> enchantmentRegistry = new RegistryReaderForge<Enchantment>(ForgeRegistries.ENCHANTMENTS);
    private final IRegistryReader<PaintingVariant> paintingRegistry = new RegistryReaderForge<PaintingVariant>(ForgeRegistries.PAINTING_VARIANTS);
    private final IRegistryReader<MobEffect> mobEffectRegistry = new RegistryReaderForge<MobEffect>(ForgeRegistries.MOB_EFFECTS);
    private final IRegistryReader<Potion> potionRegistry = new RegistryReaderForge<Potion>(ForgeRegistries.POTIONS);
    private final IRegistryReader<Attribute> attributeRegistry = new RegistryReaderForge<Attribute>(ForgeRegistries.ATTRIBUTES);
    private final IRegistryReader<VillagerProfession> professionRegistry = new RegistryReaderForge<VillagerProfession>(ForgeRegistries.VILLAGER_PROFESSIONS);
    private final IRegistryReader<SoundEvent> soundRegistry = new RegistryReaderForge<SoundEvent>(ForgeRegistries.SOUND_EVENTS);
    private final IRegistryReader<MenuType<?>> menuRegistry = new RegistryReaderForge(ForgeRegistries.MENU_TYPES);
    private final IRegistryReader<ParticleType<?>> particleRegistry = new RegistryReaderForge(ForgeRegistries.PARTICLE_TYPES);
    private final IRegistryReader<EntityType<?>> entityRegistry = new RegistryReaderForge(ForgeRegistries.ENTITY_TYPES);
    private final IRegistryReader<BlockEntityType<?>> blockEntityRegistry = new RegistryReaderForge(ForgeRegistries.BLOCK_ENTITY_TYPES);
    private final IRegistryReader<GameEvent> gameEventRegistry = new RegistryReaderVanilla<GameEvent>((Registry<GameEvent>)Registry.f_175412_);
    private final IRegistryReader<VillagerType> villagerTypeRegistry = new RegistryReaderVanilla<VillagerType>((Registry<VillagerType>)Registry.f_122868_);

    @Override
    public IRegistryReader<Block> blocks() {
        return this.blockRegistry;
    }

    @Override
    public IRegistryReader<Item> items() {
        return this.itemRegistry;
    }

    @Override
    public IRegistryReader<BannerPattern> bannerPatterns() {
        return this.bannerPatternRegistry;
    }

    @Override
    public IRegistryReader<Enchantment> enchantments() {
        return this.enchantmentRegistry;
    }

    @Override
    public IRegistryReader<PaintingVariant> paintings() {
        return this.paintingRegistry;
    }

    @Override
    public IRegistryReader<MobEffect> mobEffects() {
        return this.mobEffectRegistry;
    }

    @Override
    public IRegistryReader<Potion> potions() {
        return this.potionRegistry;
    }

    @Override
    public IRegistryReader<Attribute> attributes() {
        return this.attributeRegistry;
    }

    @Override
    public IRegistryReader<VillagerProfession> villagerProfessions() {
        return this.professionRegistry;
    }

    @Override
    public IRegistryReader<VillagerType> villagerTypes() {
        return this.villagerTypeRegistry;
    }

    @Override
    public IRegistryReader<SoundEvent> sounds() {
        return this.soundRegistry;
    }

    @Override
    public IRegistryReader<MenuType<?>> menuTypes() {
        return this.menuRegistry;
    }

    @Override
    public IRegistryReader<ParticleType<?>> particles() {
        return this.particleRegistry;
    }

    @Override
    public IRegistryReader<EntityType<?>> entities() {
        return this.entityRegistry;
    }

    @Override
    public IRegistryReader<BlockEntityType<?>> blockEntities() {
        return this.blockEntityRegistry;
    }

    @Override
    public IRegistryReader<GameEvent> gameEvents() {
        return this.gameEventRegistry;
    }

    @Override
    public void loadContent(RegistryDataProvider content) {
        this.consumeRegistry(content.blocks, Registry.f_122901_);
        this.consumeRegistry(content.fluids, Registry.f_122899_);
        this.consumeRegistry(content.items, Registry.f_122904_);
        this.consumeRegistry(content.bannerPatterns, Registry.f_235735_);
        this.consumeRegistry(content.mobEffects, Registry.f_122900_);
        this.consumeRegistry(content.sounds, Registry.f_122898_);
        this.consumeRegistry(content.potions, Registry.f_122905_);
        this.consumeRegistry(content.enchantments, Registry.f_122902_);
        this.consumeRegistry(content.entities, Registry.f_122903_);
        this.consumeRegistry(content.blockEntities, Registry.f_122907_);
        this.consumeRegistry(content.particleTypes, Registry.f_122906_);
        this.consumeRegistry(content.menus, Registry.f_122913_);
        this.consumeRegistry(content.recipeSerializers, Registry.f_122915_);
        this.consumeRegistry(content.paintings, Registry.f_235743_);
        this.consumeRegistry(content.attributes, Registry.f_122916_);
        this.consumeRegistry(content.stats, Registry.f_122917_);
        this.consumeRegistry(content.villagerProfessions, Registry.f_122809_);
        this.consumeRegistry(content.recipeTypes, Registry.f_122914_);
        this.consumeArgumentTypes(content.commandArguments);
        this.consumeWithForgeEvent(content.commands, RegisterCommandsEvent.class, (event, id, builder) -> builder.build((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection()));
        ForgeEventHelper.addContextListener(VillagerTradesEvent.class, content.trades.getVillagerTrades(), this::registerVillagerTrades);
        ForgeEventHelper.addContextListener(WandererTradesEvent.class, content.trades.getCommonWanderingTrades(), content.trades.getRareWanderingTrades(), this::registerWanderingTrades);
        this.consumeWithForgeEvent(content.dataListeners, AddReloadListenerEvent.class, (event, id, arg) -> event.addListener(arg));
        if (Services.PLATFORM.isPhysicalClient()) {
            this.loadClient(content);
        }
    }

    private void loadClient(RegistryDataProvider content) {
        this.consumeWithModEvent(content.resourceListeners, RegisterClientReloadListenersEvent.class, (event, id, arg) -> event.registerReloadListener(arg));
    }

    private void registerVillagerTrades(VillagerTradesEvent event, Map<VillagerProfession, Multimap<Integer, VillagerTrades.ItemListing>> trades) {
        Multimap<Integer, VillagerTrades.ItemListing> newTrades = trades.get(event.getType());
        if (newTrades != null) {
            Int2ObjectMap tradeData = event.getTrades();
            for (Map.Entry entry : newTrades.entries()) {
                ((List)tradeData.computeIfAbsent((Object)((Integer)entry.getKey()), ArrayList::new)).add((VillagerTrades.ItemListing)entry.getValue());
            }
        }
    }

    private void registerWanderingTrades(WandererTradesEvent event, List<VillagerTrades.ItemListing> common, List<VillagerTrades.ItemListing> rare) {
        event.getGenericTrades().addAll(common);
        event.getRareTrades().addAll(rare);
    }

    private <ET extends Event, RT> void consumeWithForgeEvent(IRegistryEntries<RT> registry, Class<ET> eventType, EventConsumer<ET, RT> func) {
        Consumer<Event> listener = event -> registry.build((id, value) -> func.apply(event, (ResourceLocation)id, value));
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, eventType, listener);
    }

    private <ET extends Event, RT> void consumeWithModEvent(IRegistryEntries<RT> registry, Class<ET> eventType, EventConsumer<ET, RT> func) {
        Consumer<Event> listener = event -> registry.build((id, value) -> func.apply(event, (ResourceLocation)id, value));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, eventType, listener);
    }

    private <T> void consumeRegistry(IRegistryEntries<T> registry, ResourceKey<? extends Registry<T>> registryKey) {
        this.consumeRegistry(registry, registryKey, v -> v);
    }

    private <T> void consumeRegistry(IRegistryEntries<T> registry, ResourceKey<? extends Registry<T>> registryKey, Function<T, ? extends T> wrapper) {
        Consumer<RegisterEvent> listener = event -> {
            if (event.getRegistryKey().equals((Object)registryKey)) {
                registry.build((id, value) -> event.register(registryKey, id, () -> wrapper.apply(value)));
            }
        };
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, RegisterEvent.class, listener);
    }

    private void consumeArgumentTypes(IRegistryEntries<CommandArgumentEntry<?, ?, ?>> registry) {
        if (registry.isEmpty()) {
            return;
        }
        Consumer<RegisterEvent> listener = event -> {
            if (event.getRegistryKey().equals((Object)Registry.f_235724_)) {
                registry.build((id, value) -> event.register(Registry.f_235724_, id, () -> {
                    ArgumentTypeInfo serializer = (ArgumentTypeInfo)value.getSerializer().get();
                    ArgumentTypeInfos.registerByClass(value.getType(), (ArgumentTypeInfo)serializer);
                    return serializer;
                }));
            }
        };
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, RegisterEvent.class, listener);
    }

    static interface EventConsumer<E extends Event, V> {
        public void apply(E var1, ResourceLocation var2, V var3);
    }
}

