/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.adventure.loot.AffixLootEntry;
import shadows.apotheosis.adventure.loot.AffixLootManager;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;

public class MiscDatagenCode {
    public static void genAffixLootItems() {
        Gson gson = AffixLootManager.GSON;
        ImmutableSet overworld = ImmutableSet.of((Object)new ResourceLocation("overworld"));
        ImmutableSet nether = ImmutableSet.of((Object)new ResourceLocation("the_nether"));
        ImmutableSet end = ImmutableSet.of((Object)new ResourceLocation("the_end"));
        BiConsumer<String, AffixLootEntry> writerFunc = (dim, entry) -> {
            if (entry.getType().isNone()) {
                return;
            }
            File file = new File(FMLPaths.GAMEDIR.get().toFile(), "datagen/" + dim + "/" + ForgeRegistries.ITEMS.getKey((Object)entry.getStack().m_41720_()).m_135815_() + ".json");
            file.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(file);){
                gson.toJson(entry, (Appendable)writer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
        for (Item i : ForgeRegistries.ITEMS) {
            ArmorItem a;
            AffixLootEntry entry2;
            int quality;
            if (i instanceof TieredItem) {
                TieredItem t = (TieredItem)i;
                Tiers tier = (Tiers)t.m_43314_();
                if (tier != Tiers.WOOD && tier.ordinal() <= Tiers.IRON.ordinal()) {
                    AffixLootEntry entry3 = new AffixLootEntry(100 - 15 * (tier.ordinal() - 1), 1 + 3 * (tier.ordinal() - 1), new ItemStack((ItemLike)i), LootCategory.forItem(new ItemStack((ItemLike)i)), (Set<ResourceLocation>)overworld, null, LootRarity.RARE);
                    writerFunc.accept("overworld", entry3);
                }
                if (tier.ordinal() >= Tiers.IRON.ordinal() && tier.ordinal() <= Tiers.DIAMOND.ordinal() || tier == Tiers.GOLD) {
                    int weight = tier == Tiers.GOLD ? 85 : 100 - 30 * (tier.ordinal() - 2);
                    quality = tier == Tiers.GOLD ? 5 : 1 + 5 * (tier.ordinal() - 2);
                    entry2 = new AffixLootEntry(weight, quality, new ItemStack((ItemLike)i), LootCategory.forItem(new ItemStack((ItemLike)i)), (Set<ResourceLocation>)nether, LootRarity.UNCOMMON, LootRarity.EPIC);
                    writerFunc.accept("the_nether", entry2);
                }
                if (tier != Tiers.DIAMOND && tier != Tiers.NETHERITE) continue;
                int weight = tier == Tiers.DIAMOND ? 100 : 70;
                quality = tier == Tiers.DIAMOND ? 5 : 10;
                entry2 = new AffixLootEntry(weight, quality, new ItemStack((ItemLike)i), LootCategory.forItem(new ItemStack((ItemLike)i)), (Set<ResourceLocation>)end, LootRarity.RARE, LootRarity.MYTHIC);
                writerFunc.accept("the_end", entry2);
                continue;
            }
            if (!(i instanceof ArmorItem) || !((a = (ArmorItem)i).m_40401_() instanceof ArmorMaterials)) continue;
            ArmorMaterials mat = (ArmorMaterials)a.m_40401_();
            if (mat.ordinal() <= ArmorMaterials.IRON.ordinal()) {
                AffixLootEntry entry4 = new AffixLootEntry(100 - 15 * mat.ordinal(), 1 + 2 * mat.ordinal(), new ItemStack((ItemLike)i), LootCategory.ARMOR, (Set<ResourceLocation>)overworld, null, LootRarity.RARE);
                writerFunc.accept("overworld", entry4);
            }
            if (mat.ordinal() >= ArmorMaterials.IRON.ordinal() && mat.ordinal() <= ArmorMaterials.DIAMOND.ordinal()) {
                AffixLootEntry entry5 = new AffixLootEntry(100 - 15 * (mat.ordinal() - 2), 1 + 2 * (mat.ordinal() - 2), new ItemStack((ItemLike)i), LootCategory.ARMOR, (Set<ResourceLocation>)nether, LootRarity.UNCOMMON, LootRarity.EPIC);
                writerFunc.accept("the_nether", entry5);
            }
            if (mat != ArmorMaterials.DIAMOND && mat != ArmorMaterials.NETHERITE) continue;
            int weight = mat == ArmorMaterials.DIAMOND ? 100 : 70;
            quality = mat == ArmorMaterials.DIAMOND ? 5 : 10;
            entry2 = new AffixLootEntry(weight, quality, new ItemStack((ItemLike)i), LootCategory.ARMOR, (Set<ResourceLocation>)end, LootRarity.RARE, LootRarity.MYTHIC);
            writerFunc.accept("the_end", entry2);
        }
    }
}

