/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.mixin;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import shadows.apotheosis.ench.EnchModuleEvents;

@Mixin(value={ThrownTrident.class})
public abstract class ThrownTridentMixin
extends AbstractArrow
implements EnchModuleEvents.TridentGetter {
    int pierces = 0;
    Vec3 oldVel = null;
    @Shadow
    private boolean f_37556_;

    protected ThrownTridentMixin(EntityType<? extends AbstractArrow> type, Level level) {
        super(type, level);
        this.f_36701_ = new IntOpenHashSet();
    }

    @Override
    @Accessor
    public abstract ItemStack getTridentItem();

    @Inject(method={"onHitEntity(Lnet/minecraft/world/phys/EntityHitResult;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void startHitEntity(EntityHitResult res, CallbackInfo ci) {
        this.oldVel = this.m_20184_();
        if (this.f_36701_.contains(res.m_82443_().m_19879_())) {
            ci.cancel();
        }
    }

    @Inject(method={"onHitEntity(Lnet/minecraft/world/phys/EntityHitResult;)V"}, at={@At(value="TAIL")}, cancellable=true)
    public void endHitEntity(EntityHitResult res, CallbackInfo ci) {
        int pierceLevel = this.getTridentItem().getEnchantmentLevel(Enchantments.f_44961_);
        if (this.pierces++ < pierceLevel) {
            this.f_37556_ = false;
            this.m_20256_(this.oldVel);
            this.f_36701_.add(res.m_82443_().m_19879_());
        }
    }
}

