/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.table;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.ench.EnchModule;
import shadows.apotheosis.ench.EnchantmentInfo;
import shadows.apotheosis.ench.table.ApothEnchantContainer;
import shadows.apotheosis.ench.table.EnchantingStatManager;
import shadows.apotheosis.ench.table.IEnchantableItem;

public class RealEnchantmentHelper {
    public static int getEnchantmentCost(RandomSource rand, int num, float eterna, ItemStack stack) {
        int ench = stack.getEnchantmentValue();
        if (ench <= 0) {
            return 0;
        }
        int level = Math.round(eterna * 2.0f);
        if (num == 2) {
            return level;
        }
        float lowBound = 0.6f - 0.4f * (float)(1 - num);
        float highBound = 0.8f - 0.4f * (float)(1 - num);
        return Math.max(1, Math.round((float)level * Mth.m_216267_((RandomSource)rand, (float)lowBound, (float)highBound)));
    }

    public static List<EnchantmentInstance> selectEnchantment(RandomSource rand, ItemStack stack, int level, float quanta, float arcana, float rectification, boolean treasure) {
        ArrayList chosenEnchants = Lists.newArrayList();
        int enchantability = stack.getEnchantmentValue();
        int srcLevel = level;
        if (enchantability > 0) {
            float quantaFactor = 1.0f + Mth.m_216267_((RandomSource)rand, (float)(-1.0f + rectification / 100.0f), (float)1.0f) * quanta / 100.0f;
            level = Mth.m_14045_((int)Math.round((float)level * quantaFactor), (int)1, (int)((int)(EnchantingStatManager.getAbsoluteMaxEterna() * 4.0f)));
            ApothEnchantContainer.Arcana arcanaVals = ApothEnchantContainer.Arcana.getForThreshold(arcana);
            List<EnchantmentInstance> allEnchants = RealEnchantmentHelper.getAvailableEnchantmentResults(level, stack, treasure);
            Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
            allEnchants.removeIf(e -> enchants.containsKey(e.f_44947_));
            List<ArcanaEnchantmentData> possibleEnchants = allEnchants.stream().map(d -> new ArcanaEnchantmentData(arcanaVals, (EnchantmentInstance)d)).collect(Collectors.toList());
            if (!possibleEnchants.isEmpty()) {
                chosenEnchants.add(((ArcanaEnchantmentData)((Object)WeightedRandom.m_216822_((RandomSource)rand, possibleEnchants).get())).data);
                RealEnchantmentHelper.removeIncompatible(possibleEnchants, (EnchantmentInstance)Util.m_137509_((List)chosenEnchants));
                if (arcana >= 25.0f && !possibleEnchants.isEmpty()) {
                    chosenEnchants.add(((ArcanaEnchantmentData)((Object)WeightedRandom.m_216822_((RandomSource)rand, possibleEnchants).get())).data);
                    RealEnchantmentHelper.removeIncompatible(possibleEnchants, (EnchantmentInstance)Util.m_137509_((List)chosenEnchants));
                }
                if (arcana >= 75.0f && !possibleEnchants.isEmpty()) {
                    chosenEnchants.add(((ArcanaEnchantmentData)((Object)WeightedRandom.m_216822_((RandomSource)rand, possibleEnchants).get())).data);
                }
                int randomBound = 50;
                if (level > 45) {
                    level = (int)((float)srcLevel * 1.15f);
                }
                while (rand.m_188503_(randomBound) <= level) {
                    if (!chosenEnchants.isEmpty()) {
                        RealEnchantmentHelper.removeIncompatible(possibleEnchants, (EnchantmentInstance)Util.m_137509_((List)chosenEnchants));
                    }
                    if (possibleEnchants.isEmpty()) break;
                    chosenEnchants.add(((ArcanaEnchantmentData)((Object)WeightedRandom.m_216822_((RandomSource)rand, possibleEnchants).get())).data);
                    level /= 2;
                }
            }
        }
        return ((IEnchantableItem)stack.m_41720_()).selectEnchantments(chosenEnchants, rand, stack, srcLevel, quanta, arcana, treasure);
    }

    public static void removeIncompatible(List<ArcanaEnchantmentData> list, EnchantmentInstance data) {
        Iterator<ArcanaEnchantmentData> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (data.f_44947_.m_44695_(iterator.next().data.f_44947_)) continue;
            iterator.remove();
        }
    }

    public static List<EnchantmentInstance> getAvailableEnchantmentResults(int power, ItemStack stack, boolean allowTreasure) {
        ArrayList<EnchantmentInstance> list = new ArrayList<EnchantmentInstance>();
        IEnchantableItem enchi = (IEnchantableItem)stack.m_41720_();
        allowTreasure = enchi.isTreasureAllowed(stack, allowTreasure);
        block0: for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            EnchantmentInfo info = EnchModule.getEnchInfo(enchantment);
            if (info.isTreasure() && !allowTreasure || !info.isDiscoverable() || !enchantment.canApplyAtEnchantingTable(stack) && !enchi.forciblyAllowsTableEnchantment(stack, enchantment)) continue;
            for (int level = info.getMaxLevel(); level > enchantment.m_44702_() - 1; --level) {
                if (power < info.getMinPower(level) || power > info.getMaxPower(level)) continue;
                list.add(new EnchantmentInstance(enchantment, level));
                continue block0;
            }
        }
        return list;
    }

    public static class ArcanaEnchantmentData
    extends WeightedEntry.IntrusiveBase {
        EnchantmentInstance data;

        public ArcanaEnchantmentData(ApothEnchantContainer.Arcana arcana, EnchantmentInstance data) {
            super(arcana.getRarities()[data.f_44947_.m_44699_().ordinal()]);
            this.data = data;
        }
    }
}

