/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.client;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.mutable.MutableInt;
import shadows.apotheosis.adventure.client.AdventureModuleClient;
import shadows.placebo.network.MessageHelper;
import shadows.placebo.network.MessageProvider;

public class BossSpawnMessage
implements MessageProvider<BossSpawnMessage> {
    private final BlockPos pos;
    private final int color;

    public BossSpawnMessage(BlockPos pos, int color) {
        this.pos = pos;
        this.color = color;
    }

    public void write(BossSpawnMessage msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeInt(msg.color);
    }

    public BossSpawnMessage read(FriendlyByteBuf buf) {
        return new BossSpawnMessage(buf.m_130135_(), buf.readInt());
    }

    public void handle(BossSpawnMessage msg, Supplier<NetworkEvent.Context> ctx) {
        MessageHelper.handlePacket(() -> () -> AdventureModuleClient.onBossSpawn(msg.pos, BossSpawnMessage.toFloats(msg.color)), ctx);
    }

    private static float[] toFloats(int color) {
        float[] arr = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return arr;
    }

    public record BossSpawnData(BlockPos pos, float[] color, MutableInt ticks) {
    }
}

