/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.salvaging;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.cap.InternalItemHandler;
import shadows.placebo.container.FilteredSlot;
import shadows.placebo.container.PlaceboContainerMenu;

public class SalvagingMenu
extends PlaceboContainerMenu {
    protected final Player player;
    protected final ContainerLevelAccess access;
    protected final InternalItemHandler invSlots = new InternalItemHandler(21);
    protected Runnable updateButtons;

    public SalvagingMenu(int id, Inventory inv) {
        this(id, inv, ContainerLevelAccess.f_39287_);
    }

    public SalvagingMenu(int id, Inventory inv, ContainerLevelAccess access) {
        super((MenuType)Apoth.Menus.SALVAGE.get(), id, inv);
        int i;
        this.player = inv.f_35978_;
        this.access = access;
        for (i = 0; i < 15; ++i) {
            this.m_38897_((Slot)new FilteredSlot(this.invSlots, i, 8 + i % 5 * 18, 17 + i / 5 * 18, s -> AffixHelper.getRarity(s) != null){

                public void m_6654_() {
                    super.m_6654_();
                    if (SalvagingMenu.this.updateButtons != null) {
                        SalvagingMenu.this.updateButtons.run();
                    }
                }

                public int m_6641_() {
                    return 1;
                }

                public int m_5866_(ItemStack stack) {
                    return 1;
                }
            });
        }
        for (i = 0; i < 6; ++i) {
            this.m_38897_((Slot)new FilteredSlot(this.invSlots, 15 + i, 134 + i % 2 * 18, 17 + i / 2 * 18, (Predicate)Predicates.alwaysFalse()){

                public void m_6654_() {
                    super.m_6654_();
                    if (SalvagingMenu.this.updateButtons != null) {
                        SalvagingMenu.this.updateButtons.run();
                    }
                }
            });
        }
        this.addPlayerSlots(inv, 8, 84);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && AffixHelper.getRarity(stack) != null, 0, 15);
        this.mover.registerRule((stack, slot) -> slot < this.playerInvStart, this.playerInvStart, this.hotbarStart + 9);
        this.registerInvShuffleRules();
    }

    protected void addPlayerSlots(Inventory pInv, int x, int y) {
        int row;
        this.playerInvStart = this.f_38839_.size();
        for (row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)pInv, column + row * 9 + 9, x + column * 18, y + row * 18){

                    public void m_6654_() {
                        super.m_6654_();
                        if (SalvagingMenu.this.updateButtons != null) {
                            SalvagingMenu.this.updateButtons.run();
                        }
                    }
                });
            }
        }
        this.hotbarStart = this.f_38839_.size();
        for (row = 0; row < 9; ++row) {
            this.m_38897_(new Slot((Container)pInv, row, x + row * 18, y + 58){

                public void m_6654_() {
                    super.m_6654_();
                    if (SalvagingMenu.this.updateButtons != null) {
                        SalvagingMenu.this.updateButtons.run();
                    }
                }
            });
        }
    }

    public void setButtonUpdater(Runnable r) {
        this.updateButtons = r;
    }

    public boolean m_6875_(Player pPlayer) {
        return (Boolean)this.access.m_39299_((level, pos) -> level.m_8055_(pos).m_60734_() == Apoth.Blocks.SALVAGING_TABLE.get(), (Object)true);
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.access.m_39292_((level, pos) -> this.m_150411_(pPlayer, (Container)new RecipeWrapper((IItemHandlerModifiable)this.invSlots)));
    }

    public boolean m_6366_(Player player, int id) {
        if (id == 0) {
            this.salvageAll(LootRarity.COMMON);
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11862_, SoundSource.BLOCKS, 0.99f, this.level.f_46441_.m_188501_() * 0.25f + 1.0f);
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_144054_, SoundSource.BLOCKS, 0.34f, this.level.f_46441_.m_188501_() * 0.2f + 0.8f);
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_12471_, SoundSource.BLOCKS, 0.45f, this.level.f_46441_.m_188501_() * 0.5f + 0.75f);
            return true;
        }
        return super.m_6366_(player, id);
    }

    protected void giveItem(Player player, ItemStack stack) {
        if (!player.m_6084_() || player instanceof ServerPlayer && ((ServerPlayer)player).m_9232_()) {
            player.m_36176_(stack, false);
        } else {
            Inventory inventory = player.m_150109_();
            if (inventory.f_35978_ instanceof ServerPlayer) {
                inventory.m_150079_(stack);
            }
        }
    }

    protected void salvageAll(LootRarity target) {
        for (int i = 0; i < 15; ++i) {
            Slot s = this.m_38853_(i);
            ItemStack stack = s.m_7993_();
            ItemStack out = SalvagingMenu.salvageItem(stack, this.player.f_19796_);
            LootRarity rarity = AffixHelper.getRarity(stack);
            s.m_5852_(ItemStack.f_41583_);
            if (out.m_41619_() || (out = this.invSlots.insertItem(rarity.ordinal() + 15, out, false)).m_41619_()) continue;
            this.giveItem(this.player, out);
        }
    }

    public static int getSalvageCount(ItemStack stack, RandomSource rand) {
        int[] counts = SalvagingMenu.getSalvageCounts(stack);
        return rand.m_216339_(counts[0], counts[1] + 1);
    }

    public static int[] getSalvageCounts(ItemStack stack) {
        if (stack.m_41763_()) {
            int maxDmg = stack.m_41776_();
            float durability = maxDmg - stack.m_41773_();
            int ratio = (int)(durability / (float)maxDmg * 100.0f);
            int max = ratio / 20 - 1;
            return new int[]{max <= 2 ? 0 : 1, Math.max(1, max)};
        }
        return new int[]{1, 1};
    }

    public static ItemStack salvageItem(ItemStack stack, RandomSource rand) {
        LootRarity rarity = AffixHelper.getRarity(stack);
        if (rarity == null) {
            return ItemStack.f_41583_;
        }
        ItemStack mat = new ItemStack((ItemLike)AdventureModule.RARITY_MATERIALS.get((Object)rarity), SalvagingMenu.getSalvageCount(stack, rand));
        return mat;
    }
}

