/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class EnlightenedAffix
extends Affix {
    protected final Map<LootRarity, StepFunction> values;

    public EnlightenedAffix(Map<LootRarity, StepFunction> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack) == LootCategory.BREAKER && this.values.containsKey(rarity);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)Component.m_237110_((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{this.values.get(rarity).getInt(level)}).m_130940_(ChatFormatting.YELLOW));
    }

    @Override
    public InteractionResult onItemUse(ItemStack stack, LootRarity rarity, float level, UseOnContext ctx) {
        Player player = ctx.m_43723_();
        if (AdventureConfig.torchItem.get().m_6225_(ctx).m_19077_()) {
            if (ctx.m_43722_().m_41619_()) {
                ctx.m_43722_().m_41769_(1);
            }
            player.m_21120_(ctx.m_43724_()).m_41622_(this.values.get(rarity).getInt(level), (LivingEntity)player, p -> p.m_21190_(ctx.m_43724_()));
            return InteractionResult.SUCCESS;
        }
        return super.onItemUse(stack, rarity, level, ctx);
    }

    public static Affix read(JsonObject obj) {
        Map<LootRarity, StepFunction> values = AffixHelper.readValues(GsonHelper.m_13930_((JsonObject)obj, (String)"values"));
        return new EnlightenedAffix(values);
    }

    public JsonObject write() {
        return new JsonObject();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_236831_(this.values, (b, key) -> b.m_130070_(key.id()), (b, func) -> func.write(b));
    }

    public static Affix read(FriendlyByteBuf buf) {
        Map values = buf.m_236847_(b -> LootRarity.byId(b.m_130277_()), b -> StepFunction.read((FriendlyByteBuf)b));
        return new EnlightenedAffix(values);
    }
}

