/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.affix.AttributeAffix;
import shadows.apotheosis.adventure.affix.effect.CatalyzingAffix;
import shadows.apotheosis.adventure.affix.effect.CleavingAffix;
import shadows.apotheosis.adventure.affix.effect.DamageReductionAffix;
import shadows.apotheosis.adventure.affix.effect.DurableAffix;
import shadows.apotheosis.adventure.affix.effect.EnlightenedAffix;
import shadows.apotheosis.adventure.affix.effect.ExecutingAffix;
import shadows.apotheosis.adventure.affix.effect.FestiveAffix;
import shadows.apotheosis.adventure.affix.effect.MagicalArrowAffix;
import shadows.apotheosis.adventure.affix.effect.OmneticAffix;
import shadows.apotheosis.adventure.affix.effect.PotionAffix;
import shadows.apotheosis.adventure.affix.effect.PsychicAffix;
import shadows.apotheosis.adventure.affix.effect.RadialAffix;
import shadows.apotheosis.adventure.affix.effect.RetreatingAffix;
import shadows.apotheosis.adventure.affix.effect.SpectralShotAffix;
import shadows.apotheosis.adventure.affix.effect.TelepathicAffix;
import shadows.apotheosis.adventure.affix.effect.ThunderstruckAffix;
import shadows.apotheosis.adventure.affix.socket.SocketAffix;
import shadows.placebo.json.PSerializer;
import shadows.placebo.json.PlaceboJsonReloadListener;

public class AffixManager
extends PlaceboJsonReloadListener<Affix> {
    public static final AffixManager INSTANCE = new AffixManager();
    private Multimap<AffixType, Affix> byType = ImmutableMultimap.of();

    public AffixManager() {
        super(AdventureModule.LOGGER, "affixes", true, true);
    }

    protected void beginReload() {
        super.beginReload();
    }

    protected void onReload() {
        super.onReload();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.registry.values().forEach(a -> builder.put((Object)a.type, (Object)a));
        this.byType = builder.build();
        Preconditions.checkArgument((boolean)(Apoth.Affixes.SOCKET.get() instanceof SocketAffix), (Object)"Socket Affix not registered!");
        Preconditions.checkArgument((boolean)(Apoth.Affixes.DURABLE.get() instanceof DurableAffix), (Object)"Durable Affix not registered!");
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(Apotheosis.loc("attribute"), PSerializer.autoRegister((String)"Attribute Affix", AttributeAffix.class));
        this.registerSerializer(Apotheosis.loc("mob_effect"), PSerializer.autoRegister((String)"Potion Affix", PotionAffix.class));
        this.registerSerializer(Apotheosis.loc("damage_reduction"), PSerializer.autoRegister((String)"Damage Reduction Affix", DamageReductionAffix.class));
        this.registerSerializer(Apotheosis.loc("catalyzing"), PSerializer.autoRegister((String)"Catalyzing Affix", CatalyzingAffix.class));
        this.registerSerializer(Apotheosis.loc("cleaving"), PSerializer.autoRegister((String)"Cleaving Affix", CleavingAffix.class));
        this.registerSerializer(Apotheosis.loc("enlightened"), PSerializer.autoRegister((String)"Enlightened Affix", EnlightenedAffix.class));
        this.registerSerializer(Apotheosis.loc("executing"), PSerializer.autoRegister((String)"Executing Affix", ExecutingAffix.class));
        this.registerSerializer(Apotheosis.loc("festive"), PSerializer.autoRegister((String)"Festive Affix", FestiveAffix.class));
        this.registerSerializer(Apotheosis.loc("magical"), PSerializer.autoRegister((String)"Magical Affix", MagicalArrowAffix.class));
        this.registerSerializer(Apotheosis.loc("omnetic"), PSerializer.autoRegister((String)"Omnetic Affix", OmneticAffix.class));
        this.registerSerializer(Apotheosis.loc("psychic"), PSerializer.autoRegister((String)"Psychic Affix", PsychicAffix.class));
        this.registerSerializer(Apotheosis.loc("radial"), PSerializer.autoRegister((String)"Radial Affix", RadialAffix.class));
        this.registerSerializer(Apotheosis.loc("retreating"), PSerializer.autoRegister((String)"Retreating Affix", RetreatingAffix.class));
        this.registerSerializer(Apotheosis.loc("spectral"), PSerializer.autoRegister((String)"Spectral Affix", SpectralShotAffix.class));
        this.registerSerializer(Apotheosis.loc("telepathic"), PSerializer.autoRegister((String)"Telepathic Affix", TelepathicAffix.class));
        this.registerSerializer(Apotheosis.loc("thunderstruck"), PSerializer.autoRegister((String)"Thunderstruck Affix", ThunderstruckAffix.class));
        this.registerSerializer(Apotheosis.loc("socket"), PSerializer.builtin((String)"Socket Affix", SocketAffix::new));
        this.registerSerializer(Apotheosis.loc("durable"), PSerializer.builtin((String)"Durable Affix", DurableAffix::new));
    }

    public Multimap<AffixType, Affix> getTypeMap() {
        return this.byType;
    }
}

