/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform;

import com.blamejared.crafttweaker.CraftTweakerCommon;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStackMutable;
import com.blamejared.crafttweaker.api.loot.modifier.ILootModifier;
import com.blamejared.crafttweaker.api.mod.Mod;
import com.blamejared.crafttweaker.api.recipe.handler.helper.CraftingTableRecipeConflictChecker;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.HandleUtil;
import com.blamejared.crafttweaker.api.villager.CTTradeObject;
import com.blamejared.crafttweaker.impl.loot.CraftTweakerPrivilegedLootModifierMap;
import com.blamejared.crafttweaker.impl.loot.ForgeLootModifierMapAdapter;
import com.blamejared.crafttweaker.mixin.common.access.food.AccessFoodPropertiesForge;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessBasicTrade;
import com.blamejared.crafttweaker.platform.helper.inventory.IItemHandlerWrapper;
import com.blamejared.crafttweaker.platform.services.IPlatformHelper;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.common.ForgeInternalHandler;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifierManager;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.items.CapabilityItemHandler;
import org.objectweb.asm.Type;

public class ForgePlatformHelper
implements IPlatformHelper {
    public Supplier<List<Mod>> modList = Suppliers.memoize(() -> ModList.get().getMods().stream().map(iModInfo -> new Mod(iModInfo.getModId(), iModInfo.getDisplayName(), iModInfo.getVersion().toString())).toList());
    public Function<String, Optional<Mod>> modFinder = Util.m_143827_(modid -> this.modList.get().stream().filter(modObject -> modObject.id().equals(modid)).findFirst());

    @Override
    public String getLogFormat() {
        return "[%d{HH:mm:ss.SSS}][%level]: %minecraftFormatting{%msg}{strip}%n%throwable";
    }

    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public boolean isDataGen() {
        return DatagenModLoader.isRunningDataGen();
    }

    @Override
    public List<Mod> getMods() {
        return this.modList.get();
    }

    @Override
    public Optional<Mod> getMod(String modid) {
        return this.modFinder.apply(modid);
    }

    @Override
    public IItemStack createItemStack(ItemStack stack) {
        return new MCItemStack(stack);
    }

    @Override
    public IItemStack createItemStackMutable(ItemStack stack) {
        return new MCItemStackMutable(stack);
    }

    @Override
    public IItemStack getEmptyItemStack() {
        return MCItemStack.EMPTY.get();
    }

    @Override
    public Fluid getBucketContent(BucketItem item) {
        return item.getFluid();
    }

    @Override
    public Path getGameDirectory() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public <T extends Annotation> Stream<? extends Class<?>> findClassesWithAnnotation(Class<T> annotationClass, Consumer<Mod> classProviderConsumer, Predicate<Either<T, Map<String, Object>>> annotationFilter) {
        Type annotationType = Type.getType(annotationClass);
        return ModList.get().getAllScanData().stream().flatMap(it -> this.fromScanData(annotationType, classProviderConsumer, annotationFilter, (ModFileScanData)it)).map(ForgePlatformHelper::getClassFromType).filter(Objects::nonNull);
    }

    @Override
    public String findMappedMethodName(Class<?> clazz, String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        return ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)methodName);
    }

    @Override
    public String findMappedFieldName(Class<?> clazz, String fieldName, Class<?> fieldType) {
        return ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)fieldName);
    }

    @Override
    public void registerCustomTradeConverters(Map<Class<? extends VillagerTrades.ItemListing>, Function<VillagerTrades.ItemListing, CTTradeObject>> classFunctionMap) {
        classFunctionMap.put(BasicItemListing.class, iTrade -> {
            if (iTrade instanceof BasicItemListing) {
                return new CTTradeObject(IItemStack.ofMutable(((AccessBasicTrade)iTrade).crafttweaker$getPrice()), IItemStack.ofMutable(((AccessBasicTrade)iTrade).crafttweaker$getPrice2()), IItemStack.ofMutable(((AccessBasicTrade)iTrade).crafttweaker$getForSale()));
            }
            throw new IllegalArgumentException("Invalid trade passed to trade function! Given: " + iTrade.getClass());
        });
    }

    @Override
    public Map<ResourceLocation, ILootModifier> getLootModifiersMap() {
        try {
            LootModifierManager manager = HandleUtil.invoke(() -> Handles.LMM_GETTER.invokeExact());
            Map<ResourceLocation, IGlobalLootModifier> map = Handles.LMM_MAP.get(manager);
            if (!(map instanceof CraftTweakerPrivilegedLootModifierMap)) {
                Map<ResourceLocation, IGlobalLootModifier> finalMap;
                map = finalMap = CraftTweakerPrivilegedLootModifierMap.of(map);
                Handles.LMM_MAP.set(manager, finalMap);
            }
            return ForgeLootModifierMapAdapter.adapt(map);
        }
        catch (IllegalStateException e) {
            return Collections.emptyMap();
        }
    }

    @Override
    public IItemHandlerWrapper getPlayerInventory(Player player) {
        return (IItemHandlerWrapper)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(IItemHandlerWrapper::new).orElseThrow(() -> new RuntimeException("Player does not have the Item Handler capability, this is probably wrong!"));
    }

    @Override
    public boolean canItemStacksStack(ItemStack first, ItemStack second) {
        if (first.m_41619_() || !first.m_41656_(second) || first.m_41782_() != second.m_41782_()) {
            return false;
        }
        return (!first.m_41782_() || first.m_41783_().equals((Object)second.m_41783_())) && first.areCapsCompatible((CapabilityProvider)second);
    }

    @Override
    public boolean doCraftingTableRecipesConflict(IRecipeManager<?> manager, Recipe<?> first, Recipe<?> second) {
        return CraftingTableRecipeConflictChecker.checkConflicts(manager, first, second);
    }

    @Override
    public Set<MutableComponent> getFluidsForDump(ItemStack stack, Player player, InteractionHand hand) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (!cap.isPresent()) {
            return Set.of();
        }
        HashSet<MutableComponent> components = new HashSet<MutableComponent>();
        cap.ifPresent(handler -> {
            int tanks = handler.getTanks();
            for (int i = 0; i < tanks; ++i) {
                components.add(Component.m_237113_((String)IFluidStack.of(handler.getFluidInTank(i)).getCommandString()));
            }
        });
        return components;
    }

    private <T extends Annotation> Stream<Type> fromScanData(Type annotationType, Consumer<Mod> classProviderConsumer, Predicate<Either<T, Map<String, Object>>> annotationFilter, ModFileScanData data) {
        return data.getAnnotations().stream().filter(it -> annotationType.equals((Object)it.annotationType())).filter(it -> annotationFilter.test(Either.right((Object)it.annotationData()))).peek(ignored -> data.getIModInfoData().stream().flatMap(it -> it.getMods().stream()).map(it -> new Mod(it.getModId(), it.getDisplayName(), it.getVersion().toString())).forEach(classProviderConsumer)).map(ModFileScanData.AnnotationData::clazz);
    }

    private static Class<?> getClassFromType(Type type) {
        try {
            return Class.forName(type.getClassName(), false, CraftTweakerCommon.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public CompoundTag getCustomData(Entity entity) {
        return entity.getPersistentData();
    }

    @Override
    public CompoundTag getPersistentData(ServerPlayer player) {
        return player.getPersistentData().m_128469_("PlayerPersisted");
    }

    @Override
    public void addFoodPropertiesEffect(FoodProperties internal, MobEffectInstance effect, float probability) {
        ((AccessFoodPropertiesForge)internal).crafttweaker$getEffects().add((Pair<Supplier<MobEffectInstance>, Float>)Pair.of(() -> effect, (Object)Float.valueOf(probability)));
    }

    @Override
    public void removeFoodPropertiesEffect(FoodProperties internal, MobEffectInstance effect) {
        ((AccessFoodPropertiesForge)internal).crafttweaker$getEffects().removeIf(pair -> pair.getFirst() != null && ((MobEffectInstance)((Supplier)pair.getFirst()).get()).equals((Object)effect));
    }

    @Override
    public void removeFoodPropertiesEffect(FoodProperties internal, MobEffect effect) {
        ((AccessFoodPropertiesForge)internal).crafttweaker$getEffects().removeIf(pair -> pair.getFirst() != null && ((MobEffectInstance)((Supplier)pair.getFirst()).get()).m_19544_() == effect);
    }

    @Override
    public void invalidateIngredients(List<Ingredient> ingredients) {
        Ingredient.invalidateAll();
        for (Ingredient ingredient : ingredients) {
            if (ingredient == null) continue;
            ingredient.checkInvalidation();
        }
        ingredients.clear();
    }

    private static final class Handles {
        private static final MethodHandle LMM_GETTER = HandleUtil.linkMethod(ForgeInternalHandler.class, HandleUtil.AccessType.STATIC, "getLootModifierManager", LootModifierManager.class, new Class[0]);
        private static final VarHandle LMM_MAP = HandleUtil.linkField(LootModifierManager.class, HandleUtil.AccessType.VIRTUAL, "registeredLootModifiers", Map.class);

        private Handles() {
        }
    }
}

