/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.tag;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister(loaders={"crafttweaker", "tags"})
@Document(value="vanilla/api/tag/MCTag")
@ZenCodeType.Name(value="crafttweaker.api.tag.MCTag")
public interface MCTag
extends CommandStringDisplayable,
Comparable<MCTag> {
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="exists")
    default public boolean exists() {
        return this.manager().exists(this.id());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="id")
    public ResourceLocation id();

    @ZenCodeType.Method
    default public void addId(ResourceLocation ... elements) {
        this.manager().addId((MCTag)GenericUtil.uncheck(this), elements);
    }

    @ZenCodeType.Method
    default public void add(MCTag ... tags) {
        this.addId((ResourceLocation[])Arrays.stream(tags).map(MCTag::idElements).flatMap(Collection::stream).toArray(ResourceLocation[]::new));
    }

    @ZenCodeType.Method
    default public void removeId(ResourceLocation ... elements) {
        this.manager().removeId((MCTag)GenericUtil.uncheck(this), elements);
    }

    @ZenCodeType.Method
    default public void remove(MCTag ... tags) {
        this.removeId((ResourceLocation[])Arrays.stream(tags).map(MCTag::idElements).flatMap(Collection::stream).toArray(ResourceLocation[]::new));
    }

    @ZenCodeType.Method
    default public void clear() {
        this.manager().clear((MCTag)GenericUtil.uncheck(this));
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean contains(ResourceLocation id) {
        return this.idElements().contains(id);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="idElements")
    default public List<ResourceLocation> idElements() {
        return this.manager().idElements((MCTag)GenericUtil.uncheck(this));
    }

    public ITagManager<?> manager();

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    default public boolean equals(MCTag other) {
        return this.id().equals((Object)other.id()) && this.manager().equals(other.manager());
    }

    default public <T extends Collection<Holder<?>>> T getInternal() {
        return (T)this.manager().getInternalRaw((MCTag)GenericUtil.uncheck(this));
    }

    default public <T extends TagKey<?>> T getTagKey() {
        return (T)TagKey.m_203882_((ResourceKey)((ResourceKey)GenericUtil.uncheck(this.manager().resourceKey())), (ResourceLocation)this.id());
    }

    @Override
    default public int compareTo(@Nonnull MCTag o) {
        return this.id().compareTo(o.id());
    }

    @Override
    default public String getCommandString() {
        return "<tag:" + this.manager().tagFolder() + ":" + this.id() + ">";
    }
}

