/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.replacement.type;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.replacement.IFilteringRule;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="vanilla/api/recipe/replacement/type/CustomFilteringRule")
@ZenCodeType.Name(value="crafttweaker.api.recipe.replacement.type.CustomFilteringRule")
@ZenRegister
public final class CustomFilteringRule
implements IFilteringRule {
    private final BiPredicate<IRecipeManager<?>, Recipe<?>> predicate;
    private final boolean requiresComputation;

    private CustomFilteringRule(BiPredicate<IRecipeManager<?>, Recipe<?>> predicate, boolean requiresComputation) {
        this.predicate = predicate;
        this.requiresComputation = requiresComputation;
    }

    @ZenCodeType.Method
    public static CustomFilteringRule of(Predicate<Recipe<?>> predicate) {
        return new CustomFilteringRule((a, b) -> predicate.test((Recipe<?>)b), false);
    }

    @ZenCodeType.Method
    public static CustomFilteringRule of(BiPredicate<IRecipeManager<?>, Recipe<?>> predicate) {
        return new CustomFilteringRule(predicate, true);
    }

    @Override
    public Stream<? extends Recipe<?>> castFilter(Stream<? extends Recipe<?>> allRecipes) {
        return allRecipes.filter(this::castFilter);
    }

    @Override
    public String describe() {
        return "a custom set of recipes";
    }

    private <C extends Container, T extends Recipe<C>> boolean castFilter(T recipe) {
        IRecipeManager manager = this.requiresComputation ? (IRecipeManager)GenericUtil.uncheck(RecipeTypeBracketHandler.getOrDefault(recipe.m_6671_())) : null;
        return this.predicate.test(manager, recipe);
    }
}

