/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.type;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.transform.IIngredientTransformer;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.world.item.crafting.Ingredient;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.ingredient.type.IIngredientTransformed")
@Document(value="vanilla/api/ingredient/type/IIngredientTransformed")
public class IIngredientTransformed<T extends IIngredient>
implements IIngredient {
    private final T base;
    private final IIngredientTransformer<T> transformer;

    public IIngredientTransformed(T base, IIngredientTransformer<T> transformer) {
        this.base = base;
        this.transformer = transformer;
    }

    @Override
    public Ingredient asVanillaIngredient() {
        return Services.REGISTRY.getIngredientTransformed(this);
    }

    @ZenCodeType.Getter(value="transformer")
    public IIngredientTransformer<T> getTransformer() {
        return this.transformer;
    }

    @Override
    public IItemStack getRemainingItem(IItemStack stack) {
        return this.transformer.transform(stack);
    }

    @Override
    public String getCommandString() {
        return this.transformer.getCommandString(this.base);
    }

    @ZenCodeType.Getter(value="baseIngredient")
    public T getBaseIngredient() {
        return this.base;
    }

    @Override
    @ZenCodeType.Method
    public boolean matches(IItemStack stack, boolean ignoreDamage) {
        return this.base.matches(stack, ignoreDamage);
    }

    @Override
    @ZenCodeType.Getter(value="items")
    public IItemStack[] getItems() {
        return this.base.getItems();
    }

    @Override
    @ZenCodeType.Caster(implicit=true)
    public MapData asMapData() {
        return this.base.asMapData();
    }

    @Override
    @ZenCodeType.Caster(implicit=true)
    public IData asIData() {
        return this.base.asIData();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IIngredientTransformed that = (IIngredientTransformed)o;
        if (!this.base.equals(that.base)) {
            return false;
        }
        return this.transformer.equals(that.transformer);
    }

    public int hashCode() {
        int result = this.base.hashCode();
        result = 31 * result + this.transformer.hashCode();
        return result;
    }
}

