/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.event;

import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.blamejared.crafttweaker.api.event.EventHandlerWrapper;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class ActionRegisterEvent<T extends Event>
implements IUndoableAction {
    private final Class<T> typeOfT;
    private final Consumer<T> consumer;
    private final EventPriority priority;

    public ActionRegisterEvent(Class<T> typeOfT, Consumer<T> consumer, EventPriority priority) {
        this.typeOfT = typeOfT;
        this.consumer = new EventHandlerWrapper<T>(consumer);
        this.priority = priority;
    }

    @Override
    public void apply() {
        MinecraftForge.EVENT_BUS.addListener(this.priority, false, this.typeOfT, this.consumer);
    }

    @Override
    public String describe() {
        return "Registering event listener for " + this.typeOfT.getSimpleName() + ".";
    }

    @Override
    public void undo() {
        MinecraftForge.EVENT_BUS.unregister(this.consumer);
    }

    @Override
    public String describeUndo() {
        return "Unregistering event listener for " + this.typeOfT.getSimpleName() + ".";
    }
}

