/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class InventoryUtil {
    public static List<ItemStack> getStacks(ICapabilityProvider provider) {
        LazyOptional inv = provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!inv.isPresent()) {
            return Collections.emptyList();
        }
        return InventoryUtil.getStacks((IItemHandler)inv.orElseThrow(NullPointerException::new));
    }

    public static List<ItemStack> getStacks(@Nullable IItemHandler handler) {
        if (handler == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack subStack = handler.getStackInSlot(slot);
            if (subStack.m_41619_()) continue;
            builder.add((Object)subStack);
        }
        return builder.build();
    }
}

