/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.recipe.liquid_burning;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.recipe.CARecipeSerializer;
import com.mrh0.createaddition.recipe.liquid_burning.LiquidBurningRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class LiquidBurningRecipeSerializer
extends CARecipeSerializer<LiquidBurningRecipe> {
    public LiquidBurningRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int burnTime = buffer.readInt();
        FluidIngredient fluid = FluidIngredient.read((FriendlyByteBuf)buffer);
        return new LiquidBurningRecipe(recipeId, fluid, burnTime);
    }

    public void toNetwork(FriendlyByteBuf buffer, LiquidBurningRecipe recipe) {
        buffer.writeInt(recipe.burnTime);
        recipe.fluidIngredients.write(buffer);
    }

    @Override
    public ItemStack getIcon() {
        return CABlocks.LIQUID_BLAZE_BURNER.asStack();
    }

    @Override
    public LiquidBurningRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        int burnTime = GsonHelper.m_13927_((JsonObject)json, (String)"burnTime");
        FluidIngredient fluid = FluidIngredient.deserialize((JsonElement)json.get("input"));
        return new LiquidBurningRecipe(recipeId, fluid, burnTime);
    }
}

