/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.recipe.conditions;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.NotNull;

public class FluidTagEmptyCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("createaddition", "fluidtag_empty");
    private final ResourceLocation tag_name;

    public FluidTagEmptyCondition(String location) {
        this(new ResourceLocation(location));
    }

    public FluidTagEmptyCondition(String namespace, String path) {
        this(new ResourceLocation(namespace, path));
    }

    public FluidTagEmptyCondition(ResourceLocation tag) {
        this.tag_name = tag;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public String toString() {
        return "fluidtag_empty(\"" + this.tag_name + "\")";
    }

    public boolean test(ICondition.IContext context) {
        @NotNull ITag tag = ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)this.tag_name));
        return tag == null || tag.isEmpty();
    }

    public static class Serializer
    implements IConditionSerializer<FluidTagEmptyCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, FluidTagEmptyCondition value) {
            json.addProperty("fluidTag", value.tag_name.toString());
        }

        public FluidTagEmptyCondition read(JsonObject json) {
            return new FluidTagEmptyCondition(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluidTag")));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

