/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public enum ConnectorMode implements StringRepresentable
{
    Push("push"),
    Pull("pull"),
    None("none"),
    Passive("passive");

    private String name;

    private ConnectorMode(String name) {
        this.name = name;
    }

    public String m_7912_() {
        return this.name;
    }

    public ConnectorMode getNext() {
        switch (this) {
            case Passive: {
                return None;
            }
            case None: {
                return Pull;
            }
            case Pull: {
                return Push;
            }
            case Push: {
                return Passive;
            }
        }
        return None;
    }

    public MutableComponent getTooltip() {
        switch (this) {
            case Passive: {
                return Component.m_237115_((String)"createaddition.tooltip.energy.passive");
            }
            case None: {
                return Component.m_237115_((String)"createaddition.tooltip.energy.none");
            }
            case Pull: {
                return Component.m_237115_((String)"createaddition.tooltip.energy.pull");
            }
            case Push: {
                return Component.m_237115_((String)"createaddition.tooltip.energy.push");
            }
        }
        return Component.m_237115_((String)"createaddition.tooltip.energy.none");
    }

    public static ConnectorMode test(Level level, BlockPos pos, Direction face) {
        BlockEntity be = level.m_7702_(pos);
        if (be == null) {
            return None;
        }
        LazyOptional optional = be.getCapability(CapabilityEnergy.ENERGY, face);
        if (!optional.isPresent()) {
            return None;
        }
        if (optional.orElse(null) == null) {
            return None;
        }
        IEnergyStorage e = (IEnergyStorage)optional.orElse(null);
        if (e.canExtract() && e.canReceive()) {
            return Passive;
        }
        if (e.canExtract()) {
            return Pull;
        }
        if (e.canReceive()) {
            return Push;
        }
        return None;
    }
}

