/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.fake_player.FakePlayerManager;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BucketHelper {
    private static final BiMap<Item, EntityType<?>> BUCKET_TO_MOB_MAP = HashBiMap.create();

    @Nullable
    public static EntityType<?> getEntityTypeFromBucket(Item bucket) {
        EntityType type = (EntityType)BUCKET_TO_MOB_MAP.get((Object)bucket);
        if (type != null) {
            return type;
        }
        if (bucket instanceof MobBucketItem) {
            MobBucketItem bucketItem = (MobBucketItem)bucket;
            EntityType<?> en = SuppPlatformStuff.getFishType(bucketItem);
            if (en != null) {
                BUCKET_TO_MOB_MAP.putIfAbsent((Object)bucket, en);
                return en;
            }
        } else {
            ResourceLocation res;
            Optional opt;
            String mobId = null;
            String itemName = Utils.getID((Item)bucket).toString();
            if (itemName.contains("_bucket")) {
                mobId = itemName.replace("_bucket", "");
            } else if (itemName.contains("bucket_of_")) {
                mobId = itemName.replace("_bucket", "");
            } else if (itemName.contains("bucket_")) {
                mobId = itemName.replace("bucket_", "");
            }
            if (mobId != null && (opt = Registry.f_122826_.m_6612_(res = new ResourceLocation(mobId))).isPresent()) {
                EntityType en = (EntityType)opt.get();
                BUCKET_TO_MOB_MAP.putIfAbsent((Object)bucket, (Object)en);
                return en;
            }
        }
        return null;
    }

    public static void tryAddingFromEntityId(String id) {
    }

    public static Collection<Item> getValidBuckets() {
        return BUCKET_TO_MOB_MAP.keySet();
    }

    public static boolean isFishBucket(Item item) {
        return BucketHelper.getEntityTypeFromBucket(item) != null;
    }

    public static void associateMobToBucketIfAbsent(EntityType<?> entity, Item item) {
        if (!BUCKET_TO_MOB_MAP.containsKey((Object)item) && !BUCKET_TO_MOB_MAP.inverse().containsKey(entity)) {
            BUCKET_TO_MOB_MAP.putIfAbsent((Object)item, entity);
        }
    }

    @Nullable
    public static ItemStack getBucketFromEntity(Entity entity) {
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            return bucketable.m_28282_();
        }
        if (entity instanceof WaterAnimal) {
            return BucketHelper.tryGettingFishBucketHackery(entity, entity.f_19853_);
        }
        return null;
    }

    private static ItemStack tryGettingFishBucketHackery(Entity entity, Level level) {
        ItemStack bucket = ItemStack.f_41583_;
        Player player = FakePlayerManager.getDefault((Level)level);
        if (player != null) {
            ItemStack filledBucket;
            player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42447_));
            InteractionResult result = entity.m_6096_(player, InteractionHand.MAIN_HAND);
            if (!result.m_19077_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42446_));
                result = entity.m_6096_(player, InteractionHand.MAIN_HAND);
            }
            if (result.m_19077_() && !(filledBucket = player.m_21120_(InteractionHand.MAIN_HAND)).m_41619_() && !entity.m_6084_()) {
                bucket = filledBucket;
            }
        }
        return bucket;
    }

    public static boolean isModdedFish(Entity entity) {
        return entity instanceof WaterAnimal || entity instanceof Bucketable;
    }
}

