/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Locale;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.ClockBlock;
import net.mehvahdjukaar.supplementaries.common.items.AbstractMobContainerItem;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.IMobContainerProvider;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class JarBlockTile
extends ItemDisplayTile
implements IMobContainerProvider,
ISoftFluidTankProvider {
    private final int capacity = CommonConfigs.Blocks.JAR_CAPACITY.get();
    public final MobContainer mobContainer;
    public final SoftFluidTank fluidHolder = SoftFluidTank.create((int)this.capacity);

    public JarBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.JAR_TILE.get(), pos, state);
        AbstractMobContainerItem item = (AbstractMobContainerItem)ModRegistry.JAR_ITEM.get();
        this.mobContainer = new MobContainer(item.getMobContainerWidth(), item.getMobContainerHeight(), true);
    }

    public void updateTileOnInventoryChanged() {
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        int light = this.fluidHolder.getFluid().getLuminosity();
        if (light != (Integer)this.m_58900_().m_61143_((Property)ModBlockProperties.LIGHT_LEVEL_0_15)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ModBlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 2);
        }
    }

    public boolean handleInteraction(Player player, InteractionHand hand, Level level, BlockPos pos) {
        ItemStack handStack = player.m_21120_(hand);
        ItemStack displayedStack = this.getDisplayedItem();
        if (this.canInteractWithSoftFluidTank() && this.fluidHolder.interactWithPlayer(player, hand, level, pos)) {
            return true;
        }
        if (this.mobContainer.isEmpty() && this.m_7013_(0, handStack)) {
            this.handleAddItem(handStack, player, hand);
            return true;
        }
        if (this.m_7983_() && this.fluidHolder.isEmpty() && this.mobContainer.interactWithBucket(handStack, level, player.m_20183_(), player, hand)) {
            return true;
        }
        if (!player.m_6144_() && CommonConfigs.Blocks.JAR_EAT.get().booleanValue()) {
            if (this.fluidHolder.tryDrinkUpFluid(player, level)) {
                return true;
            }
            if (displayedStack.m_41614_() && player.m_36391_(false) && !player.m_7500_()) {
                player.m_5584_(level, displayedStack);
                return true;
            }
        }
        return this.handleExtractItem(player, hand);
    }

    public ItemStack extractItem() {
        ItemStack myStack = this.getDisplayedItem();
        if (myStack.m_41613_() > 0) {
            return myStack.m_41620_(1);
        }
        return ItemStack.f_41583_;
    }

    public boolean handleExtractItem(Player player, InteractionHand hand) {
        if (this.getDisplayedItem().m_41720_() instanceof MobBucketItem) {
            if (player.m_21120_(hand).m_41720_() != Items.f_42446_) {
                return false;
            }
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11782_, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (!player.m_21120_(hand).m_41619_()) {
            return false;
        }
        ItemStack extracted = this.extractItem();
        if (!extracted.m_41619_()) {
            Utils.swapItem((Player)player, (InteractionHand)hand, (ItemStack)extracted);
            return true;
        }
        return false;
    }

    public void handleAddItem(ItemStack stack, @Nullable Player player, InteractionHand handIn) {
        ItemStack handStack = stack.m_41777_();
        handStack.m_41764_(1);
        Item item = handStack.m_41720_();
        this.addItem(handStack);
        if (player != null) {
            ItemStack returnStack = ItemStack.f_41583_;
            player.f_19853_.m_5594_(player, this.f_58858_, ModSounds.JAR_COOKIE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + player.f_19853_.f_46441_.m_188501_() * 0.1f);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            if (!player.m_7500_()) {
                Utils.swapItem((Player)player, (InteractionHand)handIn, (ItemStack)returnStack);
            }
        }
    }

    public void addItem(ItemStack itemstack) {
        if (this.m_7983_()) {
            NonNullList stacks = NonNullList.m_122780_((int)1, (Object)itemstack);
            this.m_6520_(stacks);
        } else {
            this.getDisplayedItem().m_41769_(Math.min(1, this.m_6893_() - this.getDisplayedItem().m_41613_()));
        }
    }

    public void resetHolders() {
        this.fluidHolder.clear();
        this.mobContainer.clear();
        this.setDisplayedItem(ItemStack.f_41583_);
    }

    public boolean isPonyJar() {
        if (this.m_8077_()) {
            Component c = this.m_7770_();
            return c != null && c.getString().toLowerCase(Locale.ROOT).contains("cum");
        }
        return false;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (CommonConfigs.Blocks.JAR_COOKIES.get().booleanValue() && this.fluidHolder.isEmpty() && this.mobContainer.isEmpty()) {
            Item i = stack.m_41720_();
            if (!this.isFull() && MiscUtils.isCookie(i)) {
                return this.m_7983_() || i == this.getDisplayedItem().m_41720_();
            }
        }
        return false;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.fluidHolder.load(compound);
        this.mobContainer.load(compound);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.fluidHolder.save(tag);
        this.mobContainer.save(tag);
    }

    public boolean hasContent() {
        return !this.m_7983_() || !this.mobContainer.isEmpty() || !this.fluidHolder.isEmpty();
    }

    public boolean isFull() {
        return this.getDisplayedItem().m_41613_() >= this.m_6893_();
    }

    public int m_6893_() {
        return this.capacity;
    }

    public Component m_6820_() {
        return Component.m_237115_((String)"block.supplementaries.jar");
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        if (!CommonConfigs.Blocks.JAR_COOKIES.get().booleanValue()) {
            return false;
        }
        return MiscUtils.isCookie(stack.m_41720_()) && (this.m_7983_() || stack.m_41720_() == this.getDisplayedItem().m_41720_());
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    @Override
    public MobContainer getMobContainer() {
        return this.mobContainer;
    }

    @Override
    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)ClockBlock.FACING);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, JarBlockTile tile) {
        tile.mobContainer.tick(pLevel, pPos);
    }

    public SoftFluidTank getSoftFluidTank() {
        return this.fluidHolder;
    }

    public boolean canInteractWithSoftFluidTank() {
        return CommonConfigs.Blocks.JAR_LIQUIDS.get() != false && this.m_7983_() && (this.mobContainer.isEmpty() || this.isPonyJar());
    }
}

