/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetTileSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetTileTarget;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

class SoftFluidTankInteraction
implements IFaucetTileSource,
IFaucetTileTarget {
    SoftFluidTankInteraction() {
    }

    @Override
    public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockEntity tile, Direction dir, @Nullable FaucetBlockTile.FillAction fillAction) {
        ISoftFluidTankProvider holder;
        if (tile instanceof ISoftFluidTankProvider && (holder = (ISoftFluidTankProvider)tile).canInteractWithSoftFluidTank()) {
            SoftFluidTank fluidHolder = holder.getSoftFluidTank();
            faucetTank.copy(fluidHolder);
            faucetTank.setCount(2);
            if (fillAction == null) {
                return InteractionResult.SUCCESS;
            }
            if (fillAction.tryExecute()) {
                fluidHolder.shrink(1);
                tile.m_6596_();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockEntity tile) {
        if (tile instanceof ISoftFluidTankProvider) {
            ISoftFluidTankProvider holder = (ISoftFluidTankProvider)tile;
            SoftFluidTank tank = holder.getSoftFluidTank();
            boolean result = faucetTank.tryTransferFluid(tank, faucetTank.getCount() - 1);
            if (result) {
                tile.m_6596_();
                faucetTank.fillCount();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }
}

