/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.block.IColored;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.blocks.LightUpWaterBlock;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CandleHolderBlock
extends LightUpWaterBlock
implements IColored {
    protected static final VoxelShape SHAPE_FLOOR = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0);
    protected static final VoxelShape SHAPE_WALL_NORTH = Block.m_49796_((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_WALL_SOUTH = Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)14.0, (double)5.0);
    protected static final VoxelShape SHAPE_WALL_WEST = Block.m_49796_((double)11.0, (double)0.0, (double)5.0, (double)16.0, (double)14.0, (double)11.0);
    protected static final VoxelShape SHAPE_WALL_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0);
    protected static final VoxelShape SHAPE_CEILING = Block.m_49796_((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;
    public static final IntegerProperty CANDLES = BlockStateProperties.f_155994_;
    private static final EnumMap<Direction, EnumMap<AttachFace, Int2ObjectMap<List<Vec3>>>> PARTICLE_OFFSETS = new EnumMap(Direction.class);
    private final DyeColor color;
    private final Supplier<ParticleType<? extends ParticleOptions>> particle;

    public CandleHolderBlock(DyeColor color, BlockBehaviour.Properties properties) {
        this(color, properties, () -> ParticleTypes.f_175834_);
    }

    public CandleHolderBlock(DyeColor color, BlockBehaviour.Properties properties, Supplier<ParticleType<? extends ParticleOptions>> particle) {
        super(properties.m_60953_(CandleHolderBlock::lightLevel));
        this.color = color;
        this.particle = particle;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_(FACE, (Comparable)AttachFace.FLOOR)).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)CANDLES, (Comparable)Integer.valueOf(1)));
    }

    private static int lightLevel(BlockState state) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            int candles = (Integer)state.m_61143_((Property)CANDLES);
            return 7 + candles * 2;
        }
        return 0;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_());
        if (blockState.m_60713_((Block)this)) {
            return (BlockState)blockState.m_61124_((Property)CANDLES, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockState.m_61143_((Property)CANDLES) + 1)));
        }
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)FACING, (Comparable)context.m_8125_()) : (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!blockstate.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return !useContext.m_7078_() && useContext.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)CANDLES) < 4 || super.m_6864_(state, useContext);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACE, FACING, CANDLES});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((AttachFace)state.m_61143_(FACE)) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> SHAPE_FLOOR;
            case AttachFace.WALL -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    default: {
                        yield SHAPE_WALL_NORTH;
                    }
                    case SOUTH: {
                        yield SHAPE_WALL_SOUTH;
                    }
                    case WEST: {
                        yield SHAPE_WALL_WEST;
                    }
                    case EAST: 
                }
                yield SHAPE_WALL_EAST;
            }
            case AttachFace.CEILING -> SHAPE_CEILING;
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ec;
        return context instanceof EntityCollisionContext && (ec = (EntityCollisionContext)context).m_193113_() instanceof Projectile ? state.m_60808_(level, pos) : Shapes.m_83040_();
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.m_61143_(FACE) == AttachFace.FLOOR) {
            return CandleHolderBlock.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
        }
        if (state.m_61143_(FACE) == AttachFace.CEILING) {
            return IRopeConnection.isSupportingCeiling(pos.m_7494_(), worldIn);
        }
        return CandleHolderBlock.isSideSolidForDirection(worldIn, pos, ((Direction)state.m_61143_((Property)FACING)).m_122424_());
    }

    private void addParticlesAndSound(Level level, Vec3 offset, RandomSource random) {
        float f = random.m_188501_();
        if (f < 0.3f) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, offset.f_82479_, offset.f_82480_, offset.f_82481_, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                level.m_7785_(offset.f_82479_ + 0.5, offset.f_82480_ + 0.5, offset.f_82481_ + 0.5, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + random.m_188501_(), random.m_188501_() * 0.7f + 0.3f, false);
            }
        }
        level.m_7106_((ParticleOptions)this.particle.get(), offset.f_82479_, offset.f_82480_, offset.f_82481_, 0.0, 0.0, 0.0);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            this.getParticleOffset(state).forEach(v -> this.addParticlesAndSound(level, v.m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), rand));
        }
    }

    private List<Vec3> getParticleOffset(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        AttachFace face = (AttachFace)state.m_61143_(FACE);
        return (List)PARTICLE_OFFSETS.get(direction).get(face).get(((Integer)state.m_61143_((Property)CANDLES)).intValue());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return CandleHolderBlock.getFacing(stateIn).m_122424_() == facing && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected static Direction getFacing(BlockState state) {
        return switch ((AttachFace)state.m_61143_(FACE)) {
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.FLOOR -> Direction.UP;
            default -> (Direction)state.m_61143_((Property)FACING);
        };
    }

    public static boolean isSideSolidForDirection(LevelReader reader, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.m_121945_(direction);
        return reader.m_8055_(blockpos).m_60783_((BlockGetter)reader, blockpos, direction.m_122424_());
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        if (!ClientConfigs.General.TOOLTIP_HINTS.get().booleanValue() || !flagIn.m_7050_()) {
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)"message.supplementaries.candle_holder").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    @Nullable
    public Item changeItemColor(@Nullable DyeColor color) {
        Supplier<Block> c = ModRegistry.CANDLE_HOLDERS.get(color);
        if (c != null) {
            return c.get().m_5456_();
        }
        return null;
    }

    public boolean supportsBlankColor() {
        return true;
    }

    public boolean canBeExtinguishedBy(ItemStack item) {
        return item.m_41619_() || super.canBeExtinguishedBy(item);
    }

    public void playExtinguishSound(LevelAccessor world, BlockPos pos) {
        world.m_5594_(null, pos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void spawnSmokeParticles(BlockState state, BlockPos pos, LevelAccessor level) {
        ((CandleHolderBlock)state.m_60734_()).getParticleOffset(state).forEach(vec3 -> level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + vec3.m_7096_(), (double)pos.m_123342_() + vec3.m_7098_(), (double)pos.m_123343_() + vec3.m_7094_(), 0.0, (double)0.1f, 0.0));
    }

    static {
        EnumMap<AttachFace, Int2ObjectMap> temp = new EnumMap<AttachFace, Int2ObjectMap>(AttachFace.class);
        Int2ObjectOpenHashMap int2ObjectMap = new Int2ObjectOpenHashMap();
        int2ObjectMap.put(1, List.of(new Vec3(0.5, 0.6875, 0.5)));
        int2ObjectMap.put(2, List.of(new Vec3(0.3125, 0.875, 0.5), new Vec3(0.6875, 0.875, 0.5)));
        int2ObjectMap.put(3, List.of(new Vec3(0.1875, 0.9375, 0.5), new Vec3(0.5, 0.9375, 0.5), new Vec3(0.8125, 0.9375, 0.5)));
        int2ObjectMap.put(4, List.of(new Vec3(0.1875, 1.0, 0.5), new Vec3(0.8125, 1.0, 0.5), new Vec3(0.5, 0.9375, 0.25), new Vec3(0.5, 0.9375, 0.75)));
        temp.put(AttachFace.FLOOR, Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2ObjectMap));
        int2ObjectMap = new Int2ObjectOpenHashMap();
        int2ObjectMap.put(1, List.of(new Vec3(0.5, 0.9375, 0.1875)));
        int2ObjectMap.put(2, List.of(new Vec3(0.3125, 0.9375, 0.1875), new Vec3(0.6875, 0.9375, 0.1875)));
        int2ObjectMap.put(3, List.of(new Vec3(0.8125, 0.9375, 0.1875), new Vec3(0.1875, 0.9375, 0.1875), new Vec3(0.5, 0.9375, 0.25)));
        int2ObjectMap.put(4, List.of(new Vec3(0.1875, 1.0, 0.1875), new Vec3(0.8125, 1.0, 0.1875), new Vec3(0.3125, 0.875, 0.3125), new Vec3(0.6875, 0.875, 0.3125)));
        temp.put(AttachFace.WALL, Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2ObjectMap));
        int2ObjectMap = new Int2ObjectOpenHashMap();
        int2ObjectMap.put(1, List.of(new Vec3(0.5, 0.5625, 0.5)));
        int2ObjectMap.put(2, List.of(new Vec3(0.25, 0.875, 0.5), new Vec3(0.75, 0.875, 0.5)));
        int2ObjectMap.put(3, List.of(new Vec3(0.5, 0.875, 0.75), new Vec3(0.75, 0.875, 0.375), new Vec3(0.25, 0.875, 0.375)));
        int2ObjectMap.put(4, List.of(new Vec3(0.1875, 0.8125, 0.1875), new Vec3(0.8125, 0.8125, 0.1875), new Vec3(0.8125, 0.8125, 0.8125), new Vec3(0.1875, 0.8125, 0.8125)));
        temp.put(AttachFace.CEILING, Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2ObjectMap));
        for (Direction direction : Direction.values()) {
            EnumMap<AttachFace, Int2ObjectMap> newFaceMap = new EnumMap<AttachFace, Int2ObjectMap>(AttachFace.class);
            for (Map.Entry faceList : temp.entrySet()) {
                Int2ObjectOpenHashMap newCandleList = new Int2ObjectOpenHashMap();
                newCandleList.defaultReturnValue(List.of());
                int c = 1;
                Int2ObjectMap oldVec = (Int2ObjectMap)faceList.getValue();
                for (int i = 1; i < 5; ++i) {
                    ArrayList<Vec3> vectorsList = new ArrayList<Vec3>();
                    for (Vec3 vec : (List)oldVec.get(i)) {
                        vectorsList.add(MthUtils.rotateVec3((Vec3)vec.m_82492_(0.5, 0.5, 0.5), (Direction)direction.m_122424_()).m_82520_(0.5, 0.5, 0.5));
                    }
                    newCandleList.put(c++, (Object)ImmutableList.copyOf(vectorsList));
                }
                newFaceMap.put(faceList.getKey(), Int2ObjectMaps.unmodifiable((Int2ObjectMap)newCandleList));
            }
            PARTICLE_OFFSETS.put(direction, newFaceMap);
        }
    }
}

