/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import dev.architectury.injectables.annotations.PlatformOnly;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BookPileBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BookPileBlock
extends WaterBlock
implements EntityBlock {
    private static final VoxelShape SHAPE_1 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
    private static final VoxelShape SHAPE_2 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape SHAPE_3 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
    private static final VoxelShape SHAPE_4 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final IntegerProperty BOOKS = ModBlockProperties.BOOKS;

    public BookPileBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOKS, (Comparable)Integer.valueOf(1)));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BookPileBlockTile) {
            BookPileBlockTile tile = (BookPileBlockTile)blockEntity;
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            tile.m_6836_((Integer)state.m_61143_((Property)BOOKS) - 1, copy);
        }
    }

    public boolean isAcceptedItem(Item i) {
        return BookPileBlock.isEnchantedBook(i) || CommonConfigs.Tweaks.MIXED_BOOKS.get() != false && BookPileBlock.isNormalBook(i);
    }

    public static boolean isEnchantedBook(Item i) {
        return i == Items.f_42690_ || BookPileBlock.isQuarkTome(i);
    }

    public static boolean isNormalBook(Item i) {
        return i.m_204114_().m_203656_(ModTags.BOOKS) || CommonConfigs.Tweaks.WRITTEN_BOOKS.get() != false && BookPileBlock.isWrittenBook(i);
    }

    public static boolean isWrittenBook(Item i) {
        return i instanceof WrittenBookItem || i instanceof WritableBookItem;
    }

    public static boolean isQuarkTome(Item i) {
        return CompatHandler.QUARK && CompatObjects.TOME.get() == i;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        Item item;
        if ((Integer)state.m_61143_((Property)BOOKS) < 4 && this.isAcceptedItem(item = context.m_43722_().m_41720_())) {
            return true;
        }
        return super.m_6864_(state, context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BOOKS});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60734_() instanceof BookPileBlock) {
            return (BlockState)blockstate.m_61124_((Property)BOOKS, (Comparable)Integer.valueOf((Integer)blockstate.m_61143_((Property)BOOKS) + 1));
        }
        return super.m_5573_(context);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60767_().m_76333_();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new BookPileBlockTile(pPos, pState, false);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof BookPileBlockTile) {
                BookPileBlockTile tile = (BookPileBlockTile)blockEntity;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)tile);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BookPileBlockTile) {
            BookPileBlockTile tile = (BookPileBlockTile)blockEntity;
            tile.m_8020_((Integer)state.m_61143_((Property)BOOKS) - 1);
        }
        return Items.f_42517_.m_7968_();
    }

    @PlatformOnly(value={"forge"})
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BookPileBlockTile) {
            BookPileBlockTile tile = (BookPileBlockTile)blockEntity;
            double f = 5.0 * (target.m_82450_().f_82480_ - (double)pos.m_123342_()) / BookPileBlock.SHAPE_4.m_83215_().f_82292_;
            return tile.m_8020_(Mth.m_14045_((int)((int)f), (int)0, (int)((Integer)state.m_61143_((Property)BOOKS) - 1)));
        }
        return Items.f_42517_.m_7968_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.m_61143_((Property)BOOKS)) {
            default -> SHAPE_1;
            case 2 -> SHAPE_2;
            case 3 -> SHAPE_3;
            case 4 -> SHAPE_4;
        };
    }

    @PlatformOnly(value={"forge"})
    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BookPileBlockTile) {
            BookPileBlockTile tile = (BookPileBlockTile)blockEntity;
            return tile.getEnchantPower();
        }
        return 0.0f;
    }
}

