/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.api.IAntiqueTextProvider;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TextHolder
implements IAntiqueTextProvider {
    private final int lines;
    private final Component[] textLines;
    private final FormattedCharSequence[] renderText;
    private final int maxWidth;
    private DyeColor color = DyeColor.BLACK;
    private boolean hasGlowingText = false;
    private boolean hasAntiqueInk = false;

    public TextHolder(int size, int maxWidth) {
        this.lines = size;
        this.maxWidth = maxWidth;
        this.renderText = new FormattedCharSequence[size];
        this.textLines = new Component[size];
        Arrays.fill(this.textLines, CommonComponents.f_237098_);
    }

    public int getMaxLineCharacters() {
        return (int)((float)this.getMaxLineVisualWidth() / 6.0f);
    }

    public int getMaxLineVisualWidth() {
        return this.maxWidth;
    }

    public void load(CompoundTag compound) {
        if (compound.m_128441_("TextHolder")) {
            CompoundTag com = compound.m_128469_("TextHolder");
            this.color = DyeColor.m_41057_((String)com.m_128461_("Color"), (DyeColor)DyeColor.BLACK);
            this.hasGlowingText = com.m_128471_("GlowingText");
            this.hasAntiqueInk = com.m_128471_("AntiqueInk");
            for (int i = 0; i < this.lines; ++i) {
                Component mutableComponent;
                String s = com.m_128461_("Text" + (i + 1));
                this.textLines[i] = mutableComponent = s.isEmpty() ? CommonComponents.f_237098_ : Component.Serializer.m_130701_((String)s);
                this.renderText[i] = null;
            }
        }
    }

    public CompoundTag save(CompoundTag compound) {
        CompoundTag com = new CompoundTag();
        com.m_128359_("Color", this.color.m_41065_());
        com.m_128379_("GlowingText", this.hasGlowingText);
        com.m_128379_("AntiqueInk", this.hasAntiqueInk);
        for (int i = 0; i < this.lines; ++i) {
            String s = Component.Serializer.m_130703_((Component)this.textLines[i]);
            com.m_128359_("Text" + (i + 1), s);
        }
        compound.m_128365_("TextHolder", (Tag)com);
        return compound;
    }

    public int size() {
        return this.lines;
    }

    public Component getLine(int line) {
        return this.textLines[line];
    }

    public void setLine(int line, Component text) {
        Style style = this.hasAntiqueInk ? Style.f_131099_.m_131150_(ModTextures.ANTIQUABLE_FONT) : Style.f_131099_;
        this.textLines[line] = text = text.m_6881_().m_6270_(style);
        this.renderText[line] = null;
    }

    public Component[] getTextLines() {
        return this.textLines;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public boolean setTextColor(DyeColor newColor) {
        if (newColor != this.color) {
            this.color = newColor;
            return true;
        }
        return false;
    }

    public boolean hasGlowingText() {
        return this.hasGlowingText;
    }

    public void setGlowingText(boolean glowing) {
        this.hasGlowingText = glowing;
    }

    public InteractionResult playerInteract(Level level, BlockPos pos, Player player, InteractionHand hand, BlockEntity tile) {
        if (player.m_150110_().f_35938_) {
            ItemStack stack = player.m_21120_(hand);
            Item item = stack.m_41720_();
            boolean success = false;
            if (item == Items.f_42532_) {
                if (this.hasGlowingText || this.hasAntiqueInk) {
                    level.m_5594_(null, pos, SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.setAntiqueInk(false);
                    this.hasGlowingText = false;
                    success = true;
                }
            } else if (item == ModRegistry.ANTIQUE_INK.get()) {
                if (!this.hasAntiqueInk) {
                    level.m_5594_(null, pos, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.setAntiqueInk(true);
                    success = true;
                }
            } else if (item == Items.f_151056_) {
                if (!this.hasGlowingText) {
                    level.m_5594_(null, pos, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.hasGlowingText = true;
                    success = true;
                }
            } else {
                DyeColor dyeColor = ForgeHelper.getColor((ItemStack)stack);
                if (dyeColor != null && this.setTextColor(dyeColor)) {
                    level.m_5594_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    success = true;
                }
            }
            if (success) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_220040_(serverPlayer, pos, stack);
                    tile.m_6596_();
                    level.m_7260_(pos, tile.m_58900_(), tile.m_58900_(), 3);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean hasAntiqueInk() {
        return this.hasAntiqueInk;
    }

    @Override
    public void setAntiqueInk(boolean hasInk) {
        this.hasAntiqueInk = hasInk;
        for (int i = 0; i < this.textLines.length; ++i) {
            this.setLine(i, this.textLines[i]);
        }
    }

    public void clearEffects() {
        this.setTextColor(DyeColor.BLACK);
        this.setAntiqueInk(false);
        this.setGlowingText(false);
    }

    public boolean isEmpty() {
        return Arrays.stream(this.textLines).allMatch(s -> s.getString().isEmpty());
    }

    public void clear() {
        Arrays.fill(this.textLines, CommonComponents.f_237098_);
        this.clearEffects();
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public FormattedCharSequence getAndPrepareTextForRenderer(Font font, int line) {
        if (this.renderText[line] == null && this.textLines[line] != CommonComponents.f_237098_) {
            List list = font.m_92923_((FormattedText)this.textLines[line], this.getMaxLineVisualWidth());
            this.renderText[line] = list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        }
        return this.renderText[line];
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextUtil.RenderTextProperties getRenderTextProperties(int combinedLight, Supplier<Boolean> shouldShowGlow) {
        return new TextUtil.RenderTextProperties(this.getColor(), this.hasGlowingText(), combinedLight, this.hasAntiqueInk() ? Style.f_131099_.m_131150_(ModTextures.ANTIQUABLE_FONT) : Style.f_131099_, shouldShowGlow);
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextUtil.RenderTextProperties getGUIRenderTextProperties() {
        return this.getRenderTextProperties(0xF000F0, () -> true);
    }
}

