/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Locale;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.TextUtils;
import net.mehvahdjukaar.supplementaries.client.renderers.VertexUtils;
import net.mehvahdjukaar.supplementaries.common.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundRequestMapDataPacket;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ComplexItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;

public class NoticeBoardBlockTileRenderer
implements BlockEntityRenderer<NoticeBoardBlockTile> {
    private final ItemRenderer itemRenderer;
    private final MapRenderer mapRenderer;
    private final Font font;
    private final Camera camera;

    public NoticeBoardBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.itemRenderer = minecraft.m_91291_();
        this.mapRenderer = minecraft.f_91063_.m_109151_();
        this.font = context.m_173586_();
        this.camera = minecraft.f_91063_.m_109153_();
    }

    public int getFrontLight(Level world, BlockPos pos, Direction dir) {
        return LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)pos.m_121945_(dir));
    }

    public boolean getAxis(Direction dir) {
        return dir == Direction.NORTH || dir == Direction.SOUTH;
    }

    public void render(NoticeBoardBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.shouldSkipTileRenderer()) {
            BlockPos pos;
            Level world = tile.m_58904_();
            if (world == null) {
                return;
            }
            ItemStack stack = tile.getDisplayedItem();
            if (stack.m_41619_()) {
                return;
            }
            Direction dir = tile.getDirection();
            float yaw = -dir.m_122435_();
            Vec3 cameraPos = this.camera.m_90583_();
            if (LOD.isOutOfFocus((Vec3)cameraPos, (BlockPos)(pos = tile.m_58899_()), (float)yaw)) {
                return;
            }
            int frontLight = this.getFrontLight(world, pos, dir);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 0.5, 0.5);
            matrixStackIn.m_85845_(RotHlpr.rot((int)((int)yaw)));
            matrixStackIn.m_85837_(0.0, 0.0, 0.5);
            MapItemSavedData mapData = MapItem.m_42853_((ItemStack)stack, (Level)world);
            if (stack.m_41720_() instanceof ComplexItem) {
                if (mapData != null) {
                    matrixStackIn.m_85836_();
                    matrixStackIn.m_85837_(0.0, 0.0, 0.008);
                    matrixStackIn.m_85841_(0.0078125f, -0.0078125f, -0.0078125f);
                    matrixStackIn.m_85837_(-64.0, -64.0, 0.0);
                    Integer integer = MapItem.m_151131_((ItemStack)stack);
                    this.mapRenderer.m_168771_(matrixStackIn, bufferIn, integer.intValue(), mapData, true, frontLight);
                    matrixStackIn.m_85849_();
                } else {
                    LocalPlayer player = Minecraft.m_91087_().f_91074_;
                    NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundRequestMapDataPacket(tile.m_58899_(), player.m_20148_()));
                }
                matrixStackIn.m_85849_();
                return;
            }
            String page = tile.getText();
            if (page != null && !page.equals("")) {
                LOD lod = new LOD(cameraPos, pos);
                if (!lod.isNearMed()) {
                    matrixStackIn.m_85849_();
                    return;
                }
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_(0.0, 0.5, 0.008);
                float d0 = this.getAxis(dir) ? 0.56f : 0.42000002f;
                if (MiscUtils.FESTIVITY.isAprilsFool()) {
                    TextUtils.renderBeeMovie(matrixStackIn, bufferIn, frontLight, this.font, d0);
                    matrixStackIn.m_85849_();
                    matrixStackIn.m_85849_();
                    return;
                }
                String bookName = tile.m_8020_(0).m_41786_().getString().toLowerCase(Locale.ROOT);
                if (bookName.equals("credits")) {
                    TextUtils.renderCredits(matrixStackIn, bufferIn, frontLight, this.font, d0);
                    matrixStackIn.m_85849_();
                    matrixStackIn.m_85849_();
                    return;
                }
                int i = tile.getTextColor().m_41071_();
                int r = (int)((double)NativeImage.m_85085_((int)i) * (double)d0);
                int g = (int)((double)NativeImage.m_85103_((int)i) * (double)d0);
                int b = (int)((double)NativeImage.m_85119_((int)i) * (double)d0);
                int i1 = NativeImage.m_84992_((int)0, (int)b, (int)g, (int)r);
                if (tile.needsVisualUpdate()) {
                    float paperWidth = 0.625f;
                    float paperHeight = 0.75f;
                    Pair p = TextUtil.fitLinesToBox((Font)this.font, (FormattedText)TextUtil.parseText((String)page), (float)paperWidth, (float)paperHeight);
                    tile.setFontScale(((Float)p.getSecond()).floatValue());
                    tile.setCachedPageLines((List)p.getFirst());
                }
                List<FormattedCharSequence> tempPageLines = tile.getCachedPageLines();
                float scale = tile.getFontScale();
                matrixStackIn.m_85841_(scale, -scale, scale);
                int numberOfLines = tempPageLines.size();
                for (int lin = 0; lin < numberOfLines; ++lin) {
                    FormattedCharSequence str = tempPageLines.get(lin);
                    float dx = (float)(-this.font.m_92724_(str) / 2) + 0.5f;
                    float dy = (1.0f / scale - (float)(8 * numberOfLines)) / 2.0f + 0.5f;
                    if (!bookName.equals("missingno")) {
                        this.font.m_92733_(str, dx, dy + (float)(8 * lin), i1, false, matrixStackIn.m_85850_().m_85861_(), bufferIn, false, 0, frontLight);
                        continue;
                    }
                    this.font.m_92811_("\u00a7ka", dx, dy + (float)(8 * lin), i1, false, matrixStackIn.m_85850_().m_85861_(), bufferIn, false, 0, frontLight);
                }
                matrixStackIn.m_85849_();
                matrixStackIn.m_85849_();
                return;
            }
            if (!stack.m_41619_() && !NoticeBoardBlockTile.isPageItem(stack.m_41720_())) {
                Material pattern = tile.getCachedPattern();
                if (pattern != null) {
                    VertexConsumer builder = pattern.m_119194_(bufferIn, RenderType::m_110482_);
                    int i = tile.getTextColor().m_41071_();
                    float b = (float)NativeImage.m_85085_((int)i) / 255.0f;
                    float g = (float)NativeImage.m_85103_((int)i) / 255.0f;
                    float r = (float)NativeImage.m_85119_((int)i) / 255.0f;
                    int lu = frontLight & 0xFFFF;
                    int lv = frontLight >> 16 & 0xFFFF;
                    VertexUtils.addQuadSide(builder, matrixStackIn, -0.4375f, -0.4375f, 0.008f, 0.4375f, 0.4375f, 0.008f, 0.15625f, 0.0625f, 0.59375f, 0.9375f, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f, pattern.m_119204_());
                } else {
                    BakedModel model = this.itemRenderer.m_174264_(stack, world, null, 0);
                    matrixStackIn.m_85837_(0.0, 0.0, 0.015675);
                    matrixStackIn.m_85841_(-0.5f, 0.5f, -0.5f);
                    this.itemRenderer.m_115143_(stack, ItemTransforms.TransformType.FIXED, true, matrixStackIn, bufferIn, frontLight, combinedOverlayIn, model);
                }
                matrixStackIn.m_85849_();
                return;
            }
            matrixStackIn.m_85849_();
        }
    }
}

