/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.block.entity.machine;

import cofh.lib.api.StorageGroup;
import cofh.lib.client.sounds.ConditionalSoundInstance;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.util.managers.machine.SawmillRecipeManager;
import cofh.thermal.expansion.init.TExpSounds;
import cofh.thermal.expansion.init.TExpTileEntities;
import cofh.thermal.expansion.inventory.container.machine.MachineSawmillContainer;
import cofh.thermal.lib.tileentity.MachineTileBase;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class MachineSawmillTile
extends MachineTileBase {
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && SawmillRecipeManager.instance().validRecipe(item));

    public MachineSawmillTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TExpTileEntities.MACHINE_SAWMILL_TILE.get(), pos, state);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlots(StorageGroup.OUTPUT, 4);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.addAugmentSlots(ThermalCoreConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return SawmillRecipeManager.instance().getBasePower();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = SawmillRecipeManager.instance().getRecipe((IThermalInventory)this);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new MachineSawmillContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    protected Object getSound() {
        return new ConditionalSoundInstance((SoundEvent)TExpSounds.SOUND_MACHINE_SAWMILL.get(), SoundSource.AMBIENT, (BlockEntity)this, () -> !this.f_58859_ && this.isActive);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        return this.inputSlot.getCount() >= (Integer)this.itemInputCounts.get(0);
    }
}

