/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.world.placement;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsbridges.module.PlacementModifierTypeModule;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.material.Material;

@MethodsReturnNonnullByDefault
public class BridgePlacement
extends PlacementModifier {
    public static final Codec<BridgePlacement> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.INT.fieldOf("length").forGetter(bridgePlacement -> bridgePlacement.length), (App)Codec.INT.fieldOf("width").forGetter(bridgePlacement -> bridgePlacement.width), (App)Codec.INT.fieldOf("min_water_z").forGetter(bridgePlacement -> bridgePlacement.minWaterZ), (App)Codec.INT.fieldOf("max_water_z").forGetter(bridgePlacement -> bridgePlacement.maxWaterZ), (App)Codec.INT.fieldOf("width_offset").forGetter(bridgePlacement -> bridgePlacement.widthOffset), (App)Codec.INT.fieldOf("num_solid_blocks_needed").forGetter(bridgePlacement -> bridgePlacement.numSolidBlocksNeeded), (App)Codec.BOOL.optionalFieldOf("is_z_axis", (Object)true).forGetter(bridgePlacement -> bridgePlacement.isZAxis)).apply((Applicative)codec, BridgePlacement::new));
    public final int length;
    public final int width;
    public final int minWaterZ;
    public final int maxWaterZ;
    public int widthOffset;
    public int numSolidBlocksNeeded;
    public boolean isZAxis;

    private BridgePlacement(int length, int width, int minWaterZ, int maxWaterZ, int widthOffset, int numSolidBlocksNeeded, boolean isZAxis) {
        this.length = length;
        this.width = width;
        this.minWaterZ = minWaterZ;
        this.maxWaterZ = maxWaterZ;
        this.widthOffset = widthOffset;
        this.numSolidBlocksNeeded = numSolidBlocksNeeded;
        this.isZAxis = isZAxis;
    }

    public Stream<BlockPos> m_213676_(PlacementContext placementContext, RandomSource randomSource, BlockPos blockPos) {
        BlockPos.MutableBlockPos seaLevelMutable = blockPos.m_122032_();
        int seaLevel = placementContext.m_191831_().m_5736_() - 1;
        seaLevelMutable.m_142448_(seaLevel);
        for (int candidateMiddleMinorAxisOffset = this.width / 2 + this.widthOffset + 1; candidateMiddleMinorAxisOffset < 16 - this.width / 2 - this.widthOffset; ++candidateMiddleMinorAxisOffset) {
            for (int candidateStartMajorAxisOffset = 0; candidateStartMajorAxisOffset < 16; ++candidateStartMajorAxisOffset) {
                int minorAxisSolidOffset;
                int minorAxisSolidDist;
                int direction;
                BlockPos endingPos;
                BlockPos startingPos = this.isZAxis ? new BlockPos(blockPos.m_123341_() + candidateMiddleMinorAxisOffset, seaLevel, blockPos.m_123343_() + candidateStartMajorAxisOffset) : new BlockPos(blockPos.m_123341_() + candidateStartMajorAxisOffset, seaLevel, blockPos.m_123343_() + candidateMiddleMinorAxisOffset);
                BlockPos blockPos2 = endingPos = this.isZAxis ? new BlockPos(blockPos.m_123341_() + candidateMiddleMinorAxisOffset, seaLevel, blockPos.m_123343_() + candidateStartMajorAxisOffset + this.length + 1) : new BlockPos(blockPos.m_123341_() + candidateStartMajorAxisOffset + this.length + 1, seaLevel, blockPos.m_123343_() + candidateMiddleMinorAxisOffset);
                if (!placementContext.m_191828_(startingPos).m_60815_() || !placementContext.m_191828_(endingPos).m_60815_() || placementContext.m_191824_(Heightmap.Types.WORLD_SURFACE, startingPos.m_123341_(), startingPos.m_123343_()) > seaLevel + 1 || placementContext.m_191824_(Heightmap.Types.WORLD_SURFACE, endingPos.m_123341_(), endingPos.m_123343_()) > seaLevel + 1) continue;
                int numSolidBlocks = 1;
                Iterator iterator = Lists.newArrayList((Object[])new Integer[]{-1, 1}).iterator();
                block2: while (iterator.hasNext()) {
                    direction = (Integer)iterator.next();
                    for (minorAxisSolidDist = 1; minorAxisSolidDist <= this.width / 2; ++minorAxisSolidDist) {
                        minorAxisSolidOffset = direction * minorAxisSolidDist;
                        if (this.isZAxis) {
                            seaLevelMutable.m_122178_(startingPos.m_123341_() + minorAxisSolidOffset, startingPos.m_123342_(), startingPos.m_123343_());
                        } else {
                            seaLevelMutable.m_122178_(startingPos.m_123341_(), startingPos.m_123342_(), startingPos.m_123343_() + minorAxisSolidOffset);
                        }
                        if (!placementContext.m_191828_((BlockPos)seaLevelMutable).m_60815_() || placementContext.m_191824_(Heightmap.Types.WORLD_SURFACE, seaLevelMutable.m_123341_(), seaLevelMutable.m_123343_()) > seaLevel + 1) continue block2;
                        ++numSolidBlocks;
                    }
                }
                if (numSolidBlocks < this.numSolidBlocksNeeded) continue;
                numSolidBlocks = 1;
                iterator = Lists.newArrayList((Object[])new Integer[]{-1, 1}).iterator();
                block4: while (iterator.hasNext()) {
                    direction = (Integer)iterator.next();
                    for (minorAxisSolidDist = 1; minorAxisSolidDist <= this.width / 2; ++minorAxisSolidDist) {
                        minorAxisSolidOffset = direction * minorAxisSolidDist;
                        if (this.isZAxis) {
                            seaLevelMutable.m_122178_(endingPos.m_123341_() + minorAxisSolidOffset, endingPos.m_123342_(), endingPos.m_123343_());
                        } else {
                            seaLevelMutable.m_122178_(endingPos.m_123341_(), endingPos.m_123342_(), endingPos.m_123343_() + minorAxisSolidOffset);
                        }
                        if (!placementContext.m_191828_((BlockPos)seaLevelMutable).m_60815_() || placementContext.m_191824_(Heightmap.Types.WORLD_SURFACE, seaLevelMutable.m_123341_(), seaLevelMutable.m_123343_()) > seaLevel + 1) continue block4;
                        ++numSolidBlocks;
                    }
                }
                if (numSolidBlocks < this.numSolidBlocksNeeded) continue;
                boolean isAllWater = true;
                block6: for (int minorAxisWaterOffset = -this.width / 2; minorAxisWaterOffset <= this.width / 2; ++minorAxisWaterOffset) {
                    for (int majorAxisWaterOffset = this.minWaterZ; majorAxisWaterOffset <= this.maxWaterZ; ++majorAxisWaterOffset) {
                        if (this.isZAxis) {
                            seaLevelMutable.m_122178_(startingPos.m_123341_() + minorAxisWaterOffset, seaLevel, startingPos.m_123343_() + majorAxisWaterOffset);
                        } else {
                            seaLevelMutable.m_122178_(startingPos.m_123341_() + majorAxisWaterOffset, seaLevel, startingPos.m_123343_() + minorAxisWaterOffset);
                        }
                        if (placementContext.m_191828_((BlockPos)seaLevelMutable).m_60767_() == Material.f_76305_) continue;
                        isAllWater = false;
                        continue block6;
                    }
                }
                if (!isAllWater) continue;
                return this.isZAxis ? Stream.of(new BlockPos(startingPos.m_123341_() - this.width / 2 - this.widthOffset, seaLevel, startingPos.m_123343_() + 1)) : Stream.of(new BlockPos(startingPos.m_123341_() + 1, seaLevel, startingPos.m_123343_() + this.width / 2 + this.widthOffset));
            }
        }
        return Stream.empty();
    }

    public PlacementModifierType<?> m_183327_() {
        return PlacementModifierTypeModule.BRIDGE_PLACEMENT;
    }
}

