/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.RenderHelper;
import vazkii.patchouli.common.util.ItemStackUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BookIcon {
    public void render(PoseStack var1, int var2, int var3);

    public static BookIcon from(String str) {
        if (str.endsWith(".png")) {
            return new TextureIcon(new ResourceLocation(str));
        }
        try {
            ItemStack stack = ItemStackUtil.loadStackFromString(str);
            return new StackIcon(stack);
        }
        catch (Exception e) {
            PatchouliAPI.LOGGER.warn("Invalid icon item stack: {}", (Object)e.getMessage());
            return new StackIcon(ItemStack.f_41583_);
        }
    }

    public record TextureIcon(ResourceLocation texture) implements BookIcon
    {
        @Override
        public void render(PoseStack ms, int x, int y) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture());
            GuiComponent.m_93133_((PoseStack)ms, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }

    public record StackIcon(ItemStack stack) implements BookIcon
    {
        @Override
        public void render(PoseStack ms, int x, int y) {
            RenderHelper.renderItemStackInGui(ms, this.stack(), x, y);
        }
    }
}

