/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.tile_entities;

import com.alc.moreminecarts.misc.SettableEnergyStorage;
import com.alc.moreminecarts.tile_entities.ContainerBlockEntity;
import com.alc.moreminecarts.tile_entities.LockingRailTile;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class AbstractCommonLoader
extends ContainerBlockEntity
implements WorldlyContainer {
    public static int MAX_COOLDOWN_TIME = 2;
    public static int FLUID_CAPACITY = 2000;
    public static int ENERGY_CAPACITY = 2000;
    public static String ENERGY_PROPERTY = "energy";
    public static String REDSTONE_OUTPUT_PROPERTY = "redstone_output";
    public static String LOCKED_MINECARTS_ONLY_PROPERTY = "locked_minecarts_only";
    public static String LEAVE_ONE_IN_STACK_PROPERTY = "leave_one_in_stack";
    public static String COMPARATOR_OUTPUT_PROPERTY = "comparator_output";
    public static String COOLDOWN_PROPERTY = "cooldown";
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return (AbstractCommonLoader.this.locked_minecarts_only ? 1 : 0) + ((AbstractCommonLoader.this.leave_one_in_stack ? 1 : 0) << 1) + (AbstractCommonLoader.this.comparator_output.toInt() << 2) + ((AbstractCommonLoader.this.redstone_output ? 1 : 0) << 4);
                }
                case 1: {
                    return AbstractCommonLoader.this.getIsUnloader() ? 1 : 0;
                }
                case 2: {
                    return AbstractCommonLoader.this.m_58899_().m_123341_();
                }
                case 3: {
                    return AbstractCommonLoader.this.m_58899_().m_123342_();
                }
                case 4: {
                    return AbstractCommonLoader.this.m_58899_().m_123343_();
                }
            }
            return 0;
        }

        public void m_8050_(int index, int set_to) {
            switch (index) {
                case 0: {
                    AbstractCommonLoader.this.locked_minecarts_only = set_to % 2 == 1;
                    AbstractCommonLoader.this.leave_one_in_stack = (set_to & 2) == 2;
                    AbstractCommonLoader.this.comparator_output = ComparatorOutputType.fromInt((set_to & 0xC) >> 2);
                    AbstractCommonLoader.this.redstone_output = (set_to & 0x10) == 16;
                    break;
                }
            }
        }

        public int m_6499_() {
            return 5;
        }
    };
    public boolean redstone_output;
    public boolean locked_minecarts_only = false;
    public boolean leave_one_in_stack = false;
    public ComparatorOutputType comparator_output;
    public boolean last_redstone_output;
    public int comparator_output_value = -1;
    public int cooldown_time;
    public boolean changed_flag;
    LazyOptional<IFluidHandler> fluid_handler = LazyOptional.of(() -> new LoaderTank(FLUID_CAPACITY));
    LazyOptional<IEnergyStorage> energy_handler = LazyOptional.of(() -> new LoaderBattery(ENERGY_CAPACITY));

    public abstract boolean getIsUnloader();

    public AbstractCommonLoader(BlockEntityType<?> p_i48285_1_, BlockPos p_155545_, BlockState p_155546_) {
        super(p_i48285_1_, p_155545_, p_155546_);
        this.comparator_output = ComparatorOutputType.done_loading;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluid_handler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy_handler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_(LOCKED_MINECARTS_ONLY_PROPERTY, this.locked_minecarts_only);
        compound.m_128379_(LEAVE_ONE_IN_STACK_PROPERTY, this.leave_one_in_stack);
        compound.m_128379_(REDSTONE_OUTPUT_PROPERTY, this.redstone_output);
        compound.m_128405_(COMPARATOR_OUTPUT_PROPERTY, this.comparator_output.toInt());
        compound.m_128405_(COOLDOWN_PROPERTY, this.cooldown_time);
        ((FluidTank)this.fluid_handler.orElse(null)).writeToNBT(compound);
        compound.m_128405_(ENERGY_PROPERTY, ((IEnergyStorage)this.energy_handler.orElse(null)).getEnergyStored());
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.locked_minecarts_only = compound.m_128471_(LOCKED_MINECARTS_ONLY_PROPERTY);
        this.leave_one_in_stack = compound.m_128471_(LEAVE_ONE_IN_STACK_PROPERTY);
        this.redstone_output = compound.m_128471_(REDSTONE_OUTPUT_PROPERTY);
        this.comparator_output = ComparatorOutputType.fromInt(compound.m_128451_(COMPARATOR_OUTPUT_PROPERTY));
        this.cooldown_time = compound.m_128451_(COOLDOWN_PROPERTY);
        this.comparator_output_value = -1;
        this.last_redstone_output = !this.redstone_output;
        FluidTank tank = (FluidTank)this.fluid_handler.orElseGet(null);
        tank.setFluid(tank.readFromNBT(compound).getFluid());
        ((IEnergyStorage)this.energy_handler.orElse(null)).receiveEnergy(compound.m_128451_(ENERGY_PROPERTY), false);
        super.m_142466_(compound);
    }

    protected List<AbstractMinecart> getLoadableMinecartsInRange() {
        if (this.locked_minecarts_only) {
            BlockEntity te_below;
            ArrayList<AbstractMinecart> acc = new ArrayList<AbstractMinecart>();
            BlockEntity te_above = this.f_58857_.m_7702_(this.m_58899_().m_7494_());
            if (te_above instanceof LockingRailTile && ((LockingRailTile)te_above).locked_minecart != null) {
                acc.add(((LockingRailTile)te_above).locked_minecart);
            }
            if ((te_below = this.f_58857_.m_7702_(this.m_58899_().m_7495_())) instanceof LockingRailTile && ((LockingRailTile)te_below).locked_minecart != null) {
                acc.add(((LockingRailTile)te_below).locked_minecart);
            }
            return acc;
        }
        return this.f_58857_.m_6443_(AbstractMinecart.class, this.getDectectionBox(), entity -> true);
    }

    protected AABB getDectectionBox() {
        BlockPos pos = this.m_58899_();
        double d0 = 0.2;
        return new AABB((double)pos.m_123341_() + 0.2, (double)pos.m_123342_() - 1.0, (double)pos.m_123343_() + 0.2, (double)(pos.m_123341_() + 1) - 0.2, (double)(pos.m_123342_() + 2) - 0.2, (double)(pos.m_123343_() + 1) - 0.2);
    }

    protected static boolean canMergeItems(ItemStack p_145894_0_, ItemStack p_145894_1_) {
        if (p_145894_0_.m_41720_() != p_145894_1_.m_41720_()) {
            return false;
        }
        if (p_145894_0_.m_41773_() != p_145894_1_.m_41773_()) {
            return false;
        }
        return p_145894_0_.m_41613_() > p_145894_0_.m_41741_() ? false : ItemStack.m_41658_((ItemStack)p_145894_0_, (ItemStack)p_145894_1_);
    }

    public void resetCooldown() {
        this.cooldown_time = MAX_COOLDOWN_TIME;
    }

    public boolean isOnCooldown() {
        return this.cooldown_time != 0;
    }

    public void decCooldown() {
        --this.cooldown_time;
        if (this.cooldown_time < 0) {
            this.cooldown_time = 0;
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.fluid_handler.invalidate();
        this.energy_handler.invalidate();
    }

    public FluidStack getFluidStack() {
        return ((IFluidHandler)this.fluid_handler.orElse(null)).getFluidInTank(0);
    }

    public int getEnergyAmount() {
        return ((IEnergyStorage)this.energy_handler.resolve().get()).getEnergyStored();
    }

    public int[] m_7071_(Direction p_180463_1_) {
        return new int[0];
    }

    public boolean m_7155_(int p_180462_1_, ItemStack p_180462_2_, @Nullable Direction p_180462_3_) {
        return true;
    }

    public boolean m_7157_(int p_180461_1_, ItemStack p_180461_2_, Direction p_180461_3_) {
        return false;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        CompoundTag compound = new CompoundTag();
        ((FluidTank)this.fluid_handler.orElse(null)).writeToNBT(compound);
        compound.m_128405_(ENERGY_PROPERTY, ((IEnergyStorage)this.energy_handler.orElse(null)).getEnergyStored());
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        ((FluidTank)this.fluid_handler.orElse(null)).writeToNBT(compound);
        compound.m_128405_(ENERGY_PROPERTY, ((IEnergyStorage)this.energy_handler.orElse(null)).getEnergyStored());
        return compound;
    }

    public void handleUpdateTag(CompoundTag tag) {
        FluidTank tank = (FluidTank)this.fluid_handler.resolve().get();
        tank.setFluid(tank.readFromNBT(tag).getFluid());
        ((SettableEnergyStorage)((Object)this.energy_handler.orElse(null))).setEnergy(tag.m_128451_(ENERGY_PROPERTY));
    }

    public void m_6596_() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            super.m_6596_();
            this.f_58857_.markAndNotifyBlock(this.m_58899_(), this.f_58857_.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 2, 0);
        }
    }

    public boolean getOutputsRedstone() {
        return this.redstone_output;
    }

    public int getSignal() {
        if (this.comparator_output_value < 0) {
            return 0;
        }
        return this.comparator_output_value;
    }

    @Override
    public int getSlotCount() {
        return 9;
    }

    public static enum ComparatorOutputType {
        done_loading,
        cart_full,
        cart_fullness;


        public int toInt() {
            switch (this) {
                case done_loading: {
                    return 0;
                }
                case cart_full: {
                    return 1;
                }
                case cart_fullness: {
                    return 2;
                }
            }
            return 3;
        }

        public static ComparatorOutputType next(ComparatorOutputType in) {
            switch (in) {
                case done_loading: {
                    return cart_full;
                }
                case cart_full: {
                    return cart_fullness;
                }
                case cart_fullness: {
                    return done_loading;
                }
            }
            return done_loading;
        }

        public static ComparatorOutputType fromInt(int n) {
            if (n == 0) {
                return done_loading;
            }
            if (n == 1) {
                return cart_full;
            }
            return cart_fullness;
        }
    }

    public class LoaderBattery
    extends SettableEnergyStorage {
        public LoaderBattery(int capacity) {
            super(capacity);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int ret = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                AbstractCommonLoader.this.changed_flag = true;
            }
            return ret;
        }

        public int extractEnergy(int maxReceive, boolean simulate) {
            int ret = super.extractEnergy(maxReceive, simulate);
            if (!simulate) {
                AbstractCommonLoader.this.changed_flag = true;
            }
            return ret;
        }
    }

    public class LoaderTank
    extends FluidTank {
        public LoaderTank(int capacity) {
            super(capacity);
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            AbstractCommonLoader.this.changed_flag = true;
        }
    }
}

