/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.items;

import com.alc.moreminecarts.registry.MMBlocks;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.registries.ForgeRegistries;

public class HoloRemoteItem
extends Item {
    public Supplier<Block> regular_block = MMBlocks.HOLO_SCAFFOLD;
    public Supplier<Block> chaotic_block = MMBlocks.CHAOTIC_HOLO_SCAFFOLD;
    public HoloRemoteType remote_type;

    public HoloRemoteItem(HoloRemoteType remote_type, Item.Properties properties) {
        super(properties);
        this.remote_type = remote_type;
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Level world = context.m_43725_();
        BlockState blockstate = world.m_8055_(blockpos);
        if (!blockstate.m_60713_(this.regular_block.get()) && !blockstate.m_60713_(this.chaotic_block.get()) || this.remote_type == HoloRemoteType.simple || this.remote_type == HoloRemoteType.broken) {
            return context;
        }
        Direction direction = context.m_7078_() ? (context.m_43721_() ? context.m_43719_().m_122424_() : context.m_43719_()) : (context.m_43719_().m_122434_() == Direction.Axis.Y ? context.m_8125_() : (this.remote_type == HoloRemoteType.regular ? Direction.UP : Direction.DOWN));
        int i = 0;
        BlockPos.MutableBlockPos blockpos$mutable = blockpos.m_122032_().m_122173_(direction);
        while (i < 30) {
            if (!world.f_46443_ && !context.m_43725_().m_46739_((BlockPos)blockpos$mutable)) {
                Player player = context.m_43723_();
                int j = world.m_151558_();
                if (!(player instanceof ServerPlayer) || blockpos$mutable.m_123342_() < j) break;
                ((ServerPlayer)player).m_215098_((Component)Component.m_237110_((String)"build.tooHigh", (Object[])new Object[]{j - 1}).m_130940_(ChatFormatting.RED), ChatType.f_130600_);
                break;
            }
            blockstate = world.m_8055_((BlockPos)blockpos$mutable);
            if (!blockstate.m_60713_(this.getBlock())) {
                if (!blockstate.m_60629_(context)) break;
                return BlockPlaceContext.m_43644_((BlockPlaceContext)context, (BlockPos)blockpos$mutable, (Direction)direction);
            }
            blockpos$mutable.m_122173_(direction);
            if (!direction.m_122434_().m_122479_()) continue;
            ++i;
        }
        return null;
    }

    public Block getBlock() {
        return this.getBlockRaw() == null ? null : (Block)ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)this.getBlockRaw()).get();
    }

    private Block getBlockRaw() {
        return this.remote_type == HoloRemoteType.broken ? this.chaotic_block.get() : this.regular_block.get();
    }

    public InteractionResult m_6225_(UseOnContext p_195939_1_) {
        InteractionResult actionresulttype = this.place(new BlockPlaceContext(p_195939_1_));
        return !actionresulttype.m_19077_() && this.m_41472_() ? this.m_7203_(p_195939_1_.m_43725_(), p_195939_1_.m_43723_(), p_195939_1_.m_43724_()).m_19089_() : actionresulttype;
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext p_195945_1_) {
        BlockState blockstate = this.getBlock().m_5573_(p_195945_1_);
        return blockstate != null && this.canPlace(p_195945_1_, blockstate) ? blockstate : null;
    }

    protected boolean canPlace(BlockPlaceContext p_195944_1_, BlockState p_195944_2_) {
        Player playerentity = p_195944_1_.m_43723_();
        CollisionContext iselectioncontext = playerentity == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)playerentity);
        return (!this.mustSurvive() || p_195944_2_.m_60710_((LevelReader)p_195944_1_.m_43725_(), p_195944_1_.m_8083_())) && p_195944_1_.m_43725_().m_45752_(p_195944_2_, p_195944_1_.m_8083_(), iselectioncontext);
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockPlaceContext p_195941_1_, BlockState p_195941_2_) {
        boolean ret = p_195941_1_.m_43725_().m_7731_(p_195941_1_.m_8083_(), p_195941_2_, 11);
        if (this.remote_type == HoloRemoteType.broken) {
            p_195941_1_.m_43725_().m_186464_(p_195941_1_.m_8083_(), p_195941_2_.m_60734_(), 2, TickPriority.VERY_LOW);
        }
        return ret;
    }

    public InteractionResult place(BlockPlaceContext context) {
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockitemusecontext = this.updatePlacementContext(context);
        if (blockitemusecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getPlacementState(blockitemusecontext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockitemusecontext, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = blockitemusecontext.m_8083_();
        Level world = blockitemusecontext.m_43725_();
        Player playerentity = blockitemusecontext.m_43723_();
        ItemStack itemstack = blockitemusecontext.m_43722_();
        BlockState blockstate1 = world.m_8055_(blockpos);
        Block block = blockstate1.m_60734_();
        if (block == blockstate.m_60734_()) {
            blockstate1 = this.updateBlockStateFromTag(blockpos, world, itemstack, blockstate1);
            this.updateCustomBlockEntityTag(blockpos, world, playerentity, itemstack, blockstate1);
            block.m_6402_(world, blockpos, blockstate1, (LivingEntity)playerentity, itemstack);
            if (playerentity instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)playerentity, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.getSoundType((LevelReader)world, blockpos, (Entity)context.m_43723_());
        world.m_5594_(playerentity, blockpos, this.getPlaceSound(blockstate1, world, blockpos, context.m_43723_()), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (playerentity == null || !playerentity.m_7500_()) {
            // empty if block
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    protected boolean updateCustomBlockEntityTag(BlockPos p_195943_1_, Level p_195943_2_, @Nullable Player p_195943_3_, ItemStack p_195943_4_, BlockState p_195943_5_) {
        return HoloRemoteItem.updateCustomBlockEntityTag(p_195943_2_, p_195943_3_, p_195943_1_, p_195943_4_);
    }

    public static boolean updateCustomBlockEntityTag(Level p_179224_0_, @Nullable Player p_179224_1_, BlockPos p_179224_2_, ItemStack p_179224_3_) {
        BlockEntity tileentity;
        MinecraftServer minecraftserver = p_179224_0_.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag compoundnbt = p_179224_3_.m_41737_("BlockEntityTag");
        if (compoundnbt != null && (tileentity = p_179224_0_.m_7702_(p_179224_2_)) != null) {
            if (!(p_179224_0_.f_46443_ || !tileentity.m_6326_() || p_179224_1_ != null && p_179224_1_.m_36337_())) {
                return false;
            }
            CompoundTag compoundnbt1 = tileentity.m_187480_();
            CompoundTag compoundnbt2 = compoundnbt1.m_6426_();
            compoundnbt1.m_128391_(compoundnbt);
            compoundnbt1.m_128405_("x", p_179224_2_.m_123341_());
            compoundnbt1.m_128405_("y", p_179224_2_.m_123342_());
            compoundnbt1.m_128405_("z", p_179224_2_.m_123343_());
            if (!compoundnbt1.equals((Object)compoundnbt2)) {
                tileentity.m_142466_(compoundnbt1);
                tileentity.m_6596_();
                return true;
            }
        }
        return false;
    }

    private BlockState updateBlockStateFromTag(BlockPos p_219985_1_, Level p_219985_2_, ItemStack p_219985_3_, BlockState p_219985_4_) {
        BlockState blockstate = p_219985_4_;
        CompoundTag compoundnbt = p_219985_3_.m_41783_();
        if (compoundnbt != null) {
            CompoundTag compoundnbt1 = compoundnbt.m_128469_("BlockStateTag");
            StateDefinition statecontainer = p_219985_4_.m_60734_().m_49965_();
            for (String s : compoundnbt1.m_128431_()) {
                Property property = statecontainer.m_61081_(s);
                if (property == null) continue;
                String s1 = compoundnbt1.m_128423_(s).m_7916_();
                blockstate = HoloRemoteItem.updateState(blockstate, property, s1);
            }
        }
        if (blockstate != p_219985_4_) {
            p_219985_2_.m_7731_(p_219985_1_, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState p_219988_0_, Property<T> p_219988_1_, String p_219988_2_) {
        return p_219988_1_.m_6215_(p_219988_2_).map(p_219986_2_ -> (BlockState)p_219988_0_.m_61124_(p_219988_1_, p_219986_2_)).orElse(p_219988_0_);
    }

    protected SoundEvent getPlaceSound(BlockState state, Level world, BlockPos pos, Player entity) {
        return state.getSoundType((LevelReader)world, pos, (Entity)entity).m_56777_();
    }

    public static enum HoloRemoteType {
        regular,
        backwards,
        simple,
        broken;

    }
}

