/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.registry.MMItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class CampfireCartEntity
extends AbstractMinecart {
    private static final EntityDataAccessor<Boolean> POWERED = SynchedEntityData.m_135353_(CampfireCartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final String PUSH_X_NAME = "PushX";
    private static final String PUSH_Z_NAME = "PushZ";
    private static final String POWERED_NAME = "powered";
    public double pushX = 0.0;
    public double pushZ = 0.0;

    public CampfireCartEntity(EntityType<?> furnaceCart, Level world) {
        super(furnaceCart, world);
    }

    public CampfireCartEntity(EntityType<?> furnaceCart, Level worldIn, double x, double y, double z) {
        super(furnaceCart, worldIn, x, y, z);
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.FURNACE;
    }

    public void m_8119_() {
        super.m_8119_();
        if (Math.abs(this.m_20184_().f_82479_ * 5.0) > this.pushX) {
            this.pushX = this.m_20184_().f_82479_;
        }
        if (Math.abs(this.m_20184_().f_82481_ * 5.0) > this.pushZ) {
            this.pushZ = this.m_20184_().f_82481_;
        }
        if (this.isMinecartPowered() && this.f_19853_.m_5776_()) {
            Vec3 pos = this.m_20182_();
            if (this.f_19796_.m_188503_(10) == 0) {
                this.f_19853_.m_7785_(pos.f_82479_, pos.f_82480_ + 0.4, pos.f_82481_, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.2f + this.f_19796_.m_188501_() / 3.0f, this.f_19796_.m_188501_() * 0.7f + 0.6f, false);
            }
            if (this.f_19796_.m_188503_(10) == 0) {
                CampfireCartEntity.spawnSmokeParticles(this.f_19853_, pos, false, false);
            }
        }
    }

    private static void spawnSmokeParticles(Level worldIn, Vec3 pos, boolean isSignalFire, boolean spawnExtraSmoke) {
        if (!worldIn.m_5776_()) {
            return;
        }
        RandomSource random = worldIn.m_213780_();
        SimpleParticleType basicparticletype = isSignalFire ? ParticleTypes.f_123778_ : ParticleTypes.f_123777_;
        worldIn.m_6493_((ParticleOptions)basicparticletype, true, pos.f_82479_ + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), pos.f_82480_ + 0.4 + random.m_188500_(), pos.f_82481_ + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
        if (spawnExtraSmoke) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_ + 0.8, pos.f_82481_, 0.0, 0.005, 0.0);
        }
    }

    protected Item m_213728_() {
        return (Item)MMItems.CAMPFIRE_CART_ITEM.get();
    }

    protected void m_6401_(BlockPos pos, BlockState state) {
        double d0 = 1.0E-4;
        double d1 = 0.001;
        super.m_6401_(pos, state);
        Vec3 vector3d = this.m_20184_();
        double d2 = vector3d.m_165925_();
        double d3 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        if (this.isMinecartPowered() && d3 > 1.0E-4 && d2 > 0.001) {
            double d4 = Math.sqrt(d2);
            double d5 = Math.sqrt(d3);
            this.pushX = vector3d.f_82479_ / d4 * d5;
            this.pushZ = vector3d.f_82481_ / d4 * d5;
        }
    }

    protected void m_7114_() {
        double d0 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        if (this.isMinecartPowered() && d0 > 1.0E-7 && this.isMinecartPowered() && !this.isGoingUphill()) {
            d0 = Math.sqrt(d0);
            this.pushX /= d0;
            this.pushZ /= d0;
            Vec3 min_motion = this.m_20184_().m_82542_(0.8, 0.0, 0.8);
            double speed_coeff = this.getSpeedDiv();
            double new_x = Math.abs(this.pushX / speed_coeff) > Math.abs(min_motion.f_82479_) ? this.pushX / speed_coeff : min_motion.f_82479_;
            double new_z = Math.abs(this.pushZ / speed_coeff) > Math.abs(min_motion.f_82481_) ? this.pushZ / speed_coeff : min_motion.f_82481_;
            this.m_20334_(new_x, min_motion.f_82480_, new_z);
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.95, 0.0, 0.95));
        }
        super.m_7114_();
    }

    public double getSpeedDiv() {
        return 11.0;
    }

    public boolean isGoingUphill() {
        int k;
        int j;
        int i = Mth.m_14107_((double)this.m_20182_().f_82479_);
        BlockPos pos = new BlockPos(i, j = Mth.m_14107_((double)this.m_20182_().f_82480_), k = Mth.m_14107_((double)this.m_20182_().f_82481_));
        BlockState state = this.f_19853_.m_8055_(pos);
        if (RailBlock.m_49416_((BlockState)state)) {
            RailShape railshape = ((BaseRailBlock)state.m_60734_()).getRailDirection(state, (BlockGetter)this.f_19853_, pos, (AbstractMinecart)this);
            boolean is_uphill = railshape == RailShape.ASCENDING_EAST || railshape == RailShape.ASCENDING_WEST || railshape == RailShape.ASCENDING_NORTH || railshape == RailShape.ASCENDING_SOUTH;
            return is_uphill;
        }
        return true;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        InteractionResult ret = super.m_6096_(player, hand);
        if (ret.m_19077_()) {
            return ret;
        }
        if (this.pushX == 0.0 && this.pushZ == 0.0) {
            this.pushX = this.m_20182_().f_82479_ - player.m_20182_().f_82479_;
            this.pushZ = this.m_20182_().f_82481_ - player.m_20182_().f_82481_;
        }
        Vec3 pos = this.m_20182_();
        if (this.f_19853_.m_5776_()) {
            if (this.isMinecartPowered()) {
                this.f_19853_.m_7785_(pos.f_82479_, pos.f_82480_ + 0.4, pos.f_82481_, SoundEvents.f_11937_, SoundSource.NEUTRAL, 0.3f, 1.0f, false);
                CampfireCartEntity.spawnSmokeParticles(this.f_19853_, this.m_20182_(), false, true);
            } else {
                this.f_19853_.m_7785_(pos.f_82479_, pos.f_82480_ + 0.4, pos.f_82481_, SoundEvents.f_11942_, SoundSource.NEUTRAL, 0.3f, this.f_19853_.m_213780_().m_188501_() * 0.4f + 0.8f, false);
            }
        }
        this.setMinecartPowered(!this.isMinecartPowered());
        return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(POWERED, (Object)false);
    }

    public boolean isMinecartPowered() {
        return (Boolean)this.f_19804_.m_135370_(POWERED);
    }

    public void setMinecartPowered(boolean powered) {
        this.f_19804_.m_135381_(POWERED, (Object)powered);
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128347_(PUSH_X_NAME, this.pushX);
        compound.m_128347_(PUSH_Z_NAME, this.pushZ);
        compound.m_128379_(POWERED_NAME, this.isMinecartPowered());
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.pushX = compound.m_128459_(PUSH_X_NAME);
        this.pushZ = compound.m_128459_(PUSH_Z_NAME);
        this.setMinecartPowered(compound.m_128471_(POWERED_NAME));
    }

    public BlockState m_6390_() {
        return (BlockState)Blocks.f_50683_.m_49966_().m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(this.isMinecartPowered()));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

