/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.client;

import com.alc.moreminecarts.containers.MinecartUnLoaderContainer;
import com.alc.moreminecarts.proxy.MoreMinecartsPacketHandler;
import com.alc.moreminecarts.tile_entities.AbstractCommonLoader;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class MinecartUnLoaderScreen
extends AbstractContainerScreen<MinecartUnLoaderContainer> {
    private static final ResourceLocation display = new ResourceLocation("moreminecarts:textures/gui/loader_gui.png");
    private final List<AbstractButton> buttons = Lists.newArrayList();

    public MinecartUnLoaderScreen(MinecartUnLoaderContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, (Component)Component.m_237115_((String)(container.getIsUnloader() ? "Minecart Unloader" : "Minecart Loader")));
    }

    public Component m_96636_() {
        return Component.m_237115_((String)(((MinecartUnLoaderContainer)this.f_97732_).getIsUnloader() ? "Minecart Unloader" : "Minecart Loader"));
    }

    private void addButton(AbstractButton p_169617_) {
        this.m_7787_((GuiEventListener)p_169617_);
        this.buttons.add(p_169617_);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addButton(new OutputTypeButton(this.f_97735_ + 46, this.f_97736_ + 19));
        this.addButton(new OnlyLockedButton(this.f_97735_ + 68, this.f_97736_ + 19));
        this.addButton(new ComparatorOutputButton(this.f_97735_ + 90, this.f_97736_ + 19));
        this.addButton(new LeaveOneInStackButton(this.f_97735_ + 112, this.f_97736_ + 19));
    }

    public void m_6305_(PoseStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.m_7333_(p_230430_1_);
        super.m_6305_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        for (AbstractButton button : this.buttons) {
            button.m_6305_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        }
        this.m_7025_(p_230430_1_, p_230430_2_, p_230430_3_);
    }

    protected void m_7286_(PoseStack matrix, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)display);
        this.m_93228_(matrix, this.f_97735_, this.f_97736_, 0, 0, 176, 166);
        Object contents_text = "";
        FluidStack fluid_stack = ((MinecartUnLoaderContainer)this.f_97732_).getFluids();
        contents_text = fluid_stack == null || fluid_stack.isEmpty() ? (String)contents_text + "0/2,000 mB fluid, " : (String)contents_text + fluid_stack.getAmount() + "/2,000 mB " + fluid_stack.getDisplayName().getString() + ", ";
        int energy_amount = ((MinecartUnLoaderContainer)this.f_97732_).getEnergy();
        contents_text = (String)contents_text + energy_amount + "/2,000 RF";
        this.f_96547_.m_92883_(matrix, (String)contents_text, (float)(this.f_97735_ + 7), (float)(this.f_97736_ + 62), 0x404040);
    }

    protected void m_7027_(PoseStack matrix, int p_230451_2_, int p_230451_3_) {
        this.f_96547_.m_92889_(matrix, this.m_96636_(), (float)this.f_97728_, (float)this.f_97729_, 0x404040);
        this.f_96547_.m_92889_(matrix, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x404040);
        for (Widget widget : this.buttons) {
            if (!((AbstractButton)widget).m_198029_()) continue;
            ((AbstractButton)widget).m_7428_(matrix, p_230451_2_ - this.f_97735_, p_230451_3_ - this.f_97736_);
            break;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class OutputTypeButton
    extends AbstractButton {
        protected OutputTypeButton(int x, int y) {
            super(x, y, 18, 18, (Component)Component.m_237119_());
        }

        public void m_7428_(PoseStack p_230443_1_, int p_230443_2_, int p_230443_3_) {
            MinecartUnLoaderScreen.this.m_96602_(p_230443_1_, (Component)Component.m_237115_((String)(((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getRedstoneOutput() ? "Output redstone activation" : "Output to comparator")), p_230443_2_, p_230443_3_);
        }

        public void m_6303_(PoseStack matrix, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            boolean mouse_on;
            RenderSystem.m_157456_((int)0, (ResourceLocation)display);
            boolean bl = mouse_on = MinecartUnLoaderScreen.this.m_7282_() && this.f_93622_;
            if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getRedstoneOutput()) {
                if (mouse_on) {
                    this.m_93228_(matrix, this.f_93620_, this.f_93621_, 230, 36, 18, 18);
                } else {
                    this.m_93228_(matrix, this.f_93620_, this.f_93621_, 212, 36, 18, 18);
                }
            } else if (mouse_on) {
                this.m_93228_(matrix, this.f_93620_, this.f_93621_, 230, 18, 18, 18);
            }
        }

        public void m_5691_() {
            MoreMinecartsPacketHandler.MinecartLoaderPacket packet = ((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getCurrentPacket();
            packet.redstone_output = !packet.redstone_output;
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)packet);
        }

        public void m_142291_(NarrationElementOutput p_169152_) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class OnlyLockedButton
    extends AbstractButton {
        protected OnlyLockedButton(int x, int y) {
            super(x, y, 18, 18, (Component)Component.m_237119_());
        }

        public void m_7428_(PoseStack p_230443_1_, int p_230443_2_, int p_230443_3_) {
            MinecartUnLoaderScreen.this.m_96602_(p_230443_1_, (Component)Component.m_237115_((String)(((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getLockedMinecartsOnly() ? "Consider only locked minecarts" : "Consider all minecarts")), p_230443_2_, p_230443_3_);
        }

        public void m_6303_(PoseStack matrix, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            boolean mouse_on;
            RenderSystem.m_157456_((int)0, (ResourceLocation)display);
            boolean bl = mouse_on = MinecartUnLoaderScreen.this.m_7282_() && this.f_93622_;
            if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getLockedMinecartsOnly()) {
                if (mouse_on) {
                    if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader()) {
                        this.m_93228_(matrix, this.f_93620_, this.f_93621_, 230, 108, 18, 18);
                    } else {
                        this.m_93228_(matrix, this.f_93620_, this.f_93621_, 194, 108, 18, 18);
                    }
                } else if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader()) {
                    this.m_93228_(matrix, this.f_93620_, this.f_93621_, 212, 108, 18, 18);
                } else {
                    this.m_93228_(matrix, this.f_93620_, this.f_93621_, 176, 108, 18, 18);
                }
            } else if (mouse_on) {
                this.m_93228_(matrix, this.f_93620_, this.f_93621_, 194, 90, 18, 18);
            }
        }

        public void m_5691_() {
            MoreMinecartsPacketHandler.MinecartLoaderPacket packet = ((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getCurrentPacket();
            packet.locked_minecarts_only = !packet.locked_minecarts_only;
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)packet);
        }

        public void m_142291_(NarrationElementOutput p_169152_) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class ComparatorOutputButton
    extends AbstractButton {
        protected ComparatorOutputButton(int x, int y) {
            super(x, y, 18, 18, (Component)Component.m_237119_());
        }

        public void m_7428_(PoseStack p_230443_1_, int p_230443_2_, int p_230443_3_) {
            MinecartUnLoaderScreen.this.m_96602_(p_230443_1_, (Component)Component.m_237115_((String)(switch (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getComparatorOutputType()) {
                case AbstractCommonLoader.ComparatorOutputType.done_loading -> "Activate output during loading inactivity";
                case AbstractCommonLoader.ComparatorOutputType.cart_full -> {
                    if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader()) {
                        yield "Activate output when cart is empty";
                    }
                    yield "Activate output when cart is full";
                }
                case AbstractCommonLoader.ComparatorOutputType.cart_fullness -> "Output cart contents";
                default -> "ERROR";
            })), p_230443_2_, p_230443_3_);
        }

        public void m_6303_(PoseStack matrix, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)display);
            boolean mouse_on = MinecartUnLoaderScreen.this.m_7282_() && this.f_93622_;
            switch (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getComparatorOutputType()) {
                case done_loading: {
                    if (mouse_on) {
                        this.m_93228_(matrix, this.f_93620_, this.f_93621_, 194, 18, 18, 18);
                        break;
                    }
                    this.m_93228_(matrix, this.f_93620_, this.f_93621_, 176, 18, 18, 18);
                    break;
                }
                case cart_full: {
                    if (mouse_on) {
                        if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader()) {
                            this.m_93228_(matrix, this.f_93620_, this.f_93621_, 230, 0, 18, 18);
                            break;
                        }
                        this.m_93228_(matrix, this.f_93620_, this.f_93621_, 194, 0, 18, 18);
                        break;
                    }
                    if (!((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader()) break;
                    this.m_93228_(matrix, this.f_93620_, this.f_93621_, 212, 0, 18, 18);
                    break;
                }
                case cart_fullness: {
                    if (mouse_on) {
                        this.m_93228_(matrix, this.f_93620_, this.f_93621_, 194, 36, 18, 18);
                        break;
                    }
                    this.m_93228_(matrix, this.f_93620_, this.f_93621_, 176, 36, 18, 18);
                    break;
                }
            }
        }

        public void m_5691_() {
            MoreMinecartsPacketHandler.MinecartLoaderPacket packet = ((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getCurrentPacket();
            packet.output_type = AbstractCommonLoader.ComparatorOutputType.next(packet.output_type);
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)packet);
        }

        public void m_142291_(NarrationElementOutput p_169152_) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class LeaveOneInStackButton
    extends AbstractButton {
        protected LeaveOneInStackButton(int x, int y) {
            super(x, y, 18, 18, (Component)Component.m_237119_());
        }

        public void m_7428_(PoseStack p_230443_1_, int p_230443_2_, int p_230443_3_) {
            MinecartUnLoaderScreen.this.m_96602_(p_230443_1_, (Component)Component.m_237115_((String)(((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader() ? (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getLeaveOneInStack() ? "Leave one item in minecart slots" : "Empty minecart slots entirely") : (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getLeaveOneInStack() ? "Leave one item in loader slots" : "Empty loader slots entirely"))), p_230443_2_, p_230443_3_);
        }

        public void m_6303_(PoseStack matrix, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            boolean mouse_on;
            RenderSystem.m_157456_((int)0, (ResourceLocation)display);
            boolean bl = mouse_on = MinecartUnLoaderScreen.this.m_7282_() && this.f_93622_;
            if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getLeaveOneInStack()) {
                if (mouse_on) {
                    if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader()) {
                        this.m_93228_(matrix, this.f_93620_, this.f_93621_, 230, 72, 18, 18);
                    } else {
                        this.m_93228_(matrix, this.f_93620_, this.f_93621_, 194, 72, 18, 18);
                    }
                } else if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader()) {
                    this.m_93228_(matrix, this.f_93620_, this.f_93621_, 212, 72, 18, 18);
                } else {
                    this.m_93228_(matrix, this.f_93620_, this.f_93621_, 176, 72, 18, 18);
                }
            } else if (mouse_on) {
                this.m_93228_(matrix, this.f_93620_, this.f_93621_, 194, 54, 18, 18);
            }
        }

        public void m_5691_() {
            MoreMinecartsPacketHandler.MinecartLoaderPacket packet = ((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getCurrentPacket();
            packet.leave_one_item_in_stack = !packet.leave_one_item_in_stack;
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)packet);
        }

        public void m_142291_(NarrationElementOutput p_169152_) {
        }
    }
}

