/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.client;

import com.alc.moreminecarts.containers.FlagCartContainer;
import com.alc.moreminecarts.proxy.MoreMinecartsPacketHandler;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlagCartScreen
extends AbstractContainerScreen<FlagCartContainer> {
    private static final ResourceLocation display = new ResourceLocation("moreminecarts:textures/gui/programmable_cart.png");
    private final List<SimpleButton> buttons = Lists.newArrayList();

    public FlagCartScreen(FlagCartContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, (Component)Component.m_237115_((String)"Signal Minecart"));
    }

    private void addButton(SimpleButton p_169617_) {
        this.m_7787_((GuiEventListener)p_169617_);
        this.buttons.add(p_169617_);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addButton(new LeftButton(this.f_97735_ + 46, this.f_97736_ + 19));
        this.addButton(new MinusButton(this.f_97735_ + 68, this.f_97736_ + 19));
        this.addButton(new PlusButton(this.f_97735_ + 90, this.f_97736_ + 19));
        this.addButton(new RightButton(this.f_97735_ + 112, this.f_97736_ + 19));
    }

    public void m_6305_(PoseStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.m_7333_(p_230430_1_);
        super.m_6305_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        for (AbstractButton abstractButton : this.buttons) {
            abstractButton.m_6305_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        }
        this.m_7025_(p_230430_1_, p_230430_2_, p_230430_3_);
    }

    protected void m_7286_(PoseStack matrix, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)display);
        this.m_93228_(matrix, this.f_97735_, this.f_97736_, 0, 0, 176, 166);
        for (int i = 0; i < ((FlagCartContainer)this.f_97732_).getDiscludedSlots(); ++i) {
            this.m_93228_(matrix, this.f_97735_ + 151 - 18 * i, this.f_97736_ + 41, 176, 36, 18, 18);
        }
        int s = ((FlagCartContainer)this.f_97732_).getSelectedSlot();
        this.m_93228_(matrix, this.f_97735_ + 4 + 18 * s, this.f_97736_ + 38, 194, 36, 24, 24);
    }

    class LeftButton
    extends SimpleButton {
        protected LeftButton(int x, int y) {
            super(x, y);
        }

        @Override
        public void renderSelected(PoseStack matrix) {
            this.m_93228_(matrix, this.f_93620_, this.f_93621_, 194, 18, 18, 18);
        }

        public void m_5691_() {
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)new MoreMinecartsPacketHandler.FlagCartPacket(false, true));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    abstract class SimpleButton
    extends AbstractButton {
        protected SimpleButton(int x, int y) {
            super(x, y, 18, 18, (Component)Component.m_237119_());
        }

        public void m_6303_(PoseStack matrix, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            boolean mouse_on;
            RenderSystem.m_157456_((int)0, (ResourceLocation)display);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean bl = mouse_on = FlagCartScreen.this.m_7282_() && this.f_93622_;
            if (mouse_on) {
                this.renderSelected(matrix);
            }
        }

        public abstract void renderSelected(PoseStack var1);

        public void m_142291_(NarrationElementOutput p_169152_) {
        }
    }

    class MinusButton
    extends SimpleButton {
        protected MinusButton(int x, int y) {
            super(x, y);
        }

        @Override
        public void renderSelected(PoseStack matrix) {
            this.m_93228_(matrix, this.f_93620_, this.f_93621_, 230, 0, 18, 18);
        }

        public void m_5691_() {
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)new MoreMinecartsPacketHandler.FlagCartPacket(true, false));
        }
    }

    class PlusButton
    extends SimpleButton {
        protected PlusButton(int x, int y) {
            super(x, y);
        }

        @Override
        public void renderSelected(PoseStack matrix) {
            this.m_93228_(matrix, this.f_93620_, this.f_93621_, 194, 0, 18, 18);
        }

        public void m_5691_() {
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)new MoreMinecartsPacketHandler.FlagCartPacket(false, false));
        }
    }

    class RightButton
    extends SimpleButton {
        protected RightButton(int x, int y) {
            super(x, y);
        }

        @Override
        public void renderSelected(PoseStack matrix) {
            this.m_93228_(matrix, this.f_93620_, this.f_93621_, 230, 18, 18, 18);
        }

        public void m_5691_() {
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)new MoreMinecartsPacketHandler.FlagCartPacket(true, true));
        }
    }
}

