/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks.rail_turns;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.BlockHitResult;

public class RailTurn
extends BaseRailBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.f_61404_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty FLIPPED = BooleanProperty.m_61465_((String)"flipped");

    public RailTurn(BlockBehaviour.Properties builder) {
        super(true, builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_6360_(BlockState state, Level worldIn, BlockPos pos, Block blockIn) {
        boolean flag2;
        boolean flag1 = (Boolean)state.m_61143_((Property)POWERED);
        if (flag1 != (flag2 = worldIn.m_46753_(pos))) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag2)), 3);
            worldIn.m_46672_(pos.m_7495_(), (Block)this);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
    }

    public Property<RailShape> m_7978_() {
        return SHAPE;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.m_6360_(state, worldIn, pos, state.m_60734_());
        }
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
    }

    protected BlockState m_49389_(BlockState state, Level world, BlockPos pos, boolean isMoving) {
        return state;
    }

    protected BlockState m_49367_(Level worldIn, BlockPos pos, BlockState state, boolean placing) {
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE, POWERED, FLIPPED, f_152149_});
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public RailShape getRailDirection(BlockState state, BlockGetter world, BlockPos pos, @Nullable AbstractMinecart cart) {
        boolean is_powered = (Boolean)state.m_61143_((Property)POWERED);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean is_x_axis = facing == Direction.NORTH || facing == Direction.SOUTH;
        boolean backwards = facing == Direction.NORTH || facing == Direction.EAST;
        boolean flipped = (Boolean)state.m_61143_((Property)FLIPPED);
        if (cart != null) {
            boolean turn_approach;
            boolean bl = is_x_axis ? Math.abs(cart.m_20184_().f_82479_) > 0.05 : (turn_approach = Math.abs(cart.m_20184_().f_82481_) > 0.05);
            if (is_powered || turn_approach) {
                boolean backwards_approach;
                boolean bl2 = backwards_approach = (!is_x_axis ? cart.m_20184_().f_82479_ : -cart.m_20184_().f_82481_) * (double)(backwards ? 1 : -1) <= 0.0 && !turn_approach;
                if (!backwards_approach) {
                    if (flipped) {
                        if (is_x_axis) {
                            return backwards ? RailShape.SOUTH_WEST : RailShape.NORTH_EAST;
                        }
                        return backwards ? RailShape.NORTH_WEST : RailShape.SOUTH_EAST;
                    }
                    if (is_x_axis) {
                        return backwards ? RailShape.SOUTH_EAST : RailShape.NORTH_WEST;
                    }
                    return backwards ? RailShape.SOUTH_WEST : RailShape.NORTH_EAST;
                }
            }
        }
        return is_x_axis ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.m_5776_()) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)FLIPPED) == false)));
            worldIn.m_5594_((Player)null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.m_19078_((boolean)worldIn.m_5776_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        state = (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        state = (BlockState)state.m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf((Boolean)(state = state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)))).m_61143_((Property)FLIPPED) == false));
        return state;
    }
}

