/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks.holographic_rails;

import com.alc.moreminecarts.blocks.holographic_rails.HolographicRail;
import com.alc.moreminecarts.misc.RailUtil;
import com.alc.moreminecarts.registry.MMBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.BlockHitResult;

public class ProjectorRail
extends BaseRailBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.f_61404_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public ProjectorRail(BlockBehaviour.Properties builder) {
        super(true, builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE, POWERED, f_152149_});
    }

    protected int getHologramLength() {
        return 5;
    }

    protected Block getHologramRail() {
        return (Block)MMBlocks.HOLOGRAM_RAIL.get();
    }

    protected void m_6360_(BlockState state, Level worldIn, BlockPos pos, Block blockIn) {
        this.updateState(state, worldIn, pos, blockIn, false);
    }

    protected void updateState(BlockState state, Level worldIn, BlockPos pos, Block blockIn, boolean force) {
        boolean now_powered;
        boolean currently_powered = (Boolean)state.m_61143_((Property)POWERED);
        if (currently_powered != (now_powered = worldIn.m_46753_(pos)) || force) {
            BlockState test_state;
            BlockPos test_pos;
            int i;
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(now_powered)), 3);
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            RailShape shape = RailUtil.FacingToShape(direction, now_powered);
            RailShape old_shape = RailUtil.FacingToShape(direction, !now_powered);
            for (i = 0; i < this.getHologramLength(); ++i) {
                test_pos = pos.m_5484_(direction, i + 1).m_6630_(!now_powered ? i : 0);
                test_state = worldIn.m_8055_(test_pos);
                if (!test_state.m_60713_(this.getHologramRail()) || test_state.m_61143_((Property)FACING) != direction || test_state.m_61143_(SHAPE) != old_shape) continue;
                if (((Boolean)test_state.m_61143_((Property)f_152149_)).booleanValue()) {
                    worldIn.m_7731_(test_pos, Blocks.f_49990_.m_49966_(), 3);
                    continue;
                }
                worldIn.m_7731_(test_pos, Blocks.f_50016_.m_49966_(), 3);
            }
            for (i = 0; i < this.getHologramLength(); ++i) {
                test_pos = pos.m_5484_(direction, i + 1).m_6630_(now_powered ? i : 0);
                test_state = worldIn.m_8055_(test_pos);
                if (test_state.m_60713_(this.getHologramRail()) && test_state.m_61143_((Property)FACING) == direction && test_state.m_61143_(SHAPE) == shape) continue;
                if (test_state.m_60795_()) {
                    worldIn.m_7731_(test_pos, (BlockState)((BlockState)((BlockState)this.getHologramRail().m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_(SHAPE, (Comparable)shape)).m_61124_((Property)HolographicRail.LENGTH, (Comparable)Integer.valueOf(i)), 3);
                    continue;
                }
                if (!test_state.m_60713_(Blocks.f_49990_) || (Integer)test_state.m_61143_((Property)LiquidBlock.f_54688_) != 0) break;
                worldIn.m_7731_(test_pos, (BlockState)((BlockState)((BlockState)((BlockState)this.getHologramRail().m_49966_().m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)direction)).m_61124_(SHAPE, (Comparable)shape)).m_61124_((Property)HolographicRail.LENGTH, (Comparable)Integer.valueOf(i)), 3);
            }
            worldIn.m_46672_(pos.m_7495_(), (Block)this);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)direction)).m_61124_(SHAPE, (Comparable)(direction.m_122434_() == Direction.Axis.Z ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST));
    }

    public Property<RailShape> m_7978_() {
        return SHAPE;
    }

    public RailShape getRailDirection(BlockState state, BlockGetter world, BlockPos pos, @Nullable AbstractMinecart cart) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.Z ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!worldIn.m_5776_()) {
            this.updateState(state, worldIn, pos, state.m_60734_(), true);
        }
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
    }

    protected BlockState m_49389_(BlockState state, Level world, BlockPos pos, boolean isMoving) {
        return state;
    }

    protected BlockState m_49367_(Level worldIn, BlockPos pos, BlockState state, boolean placing) {
        return state;
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.m_5776_()) {
            this.updateState(state, worldIn, pos, state.m_60734_(), true);
        }
        return InteractionResult.m_19078_((boolean)worldIn.m_5776_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        state = (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
        return state;
    }
}

