/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts;

import com.alc.moreminecarts.MMConstants;
import com.alc.moreminecarts.client.BatteryCartScreen;
import com.alc.moreminecarts.client.ChunkLoaderScreen;
import com.alc.moreminecarts.client.FlagCartScreen;
import com.alc.moreminecarts.client.MinecartUnLoaderScreen;
import com.alc.moreminecarts.client.TankCartScreen;
import com.alc.moreminecarts.proxy.ClientProxy;
import com.alc.moreminecarts.proxy.IProxy;
import com.alc.moreminecarts.proxy.MoreMinecartsPacketHandler;
import com.alc.moreminecarts.proxy.ServerProxy;
import com.alc.moreminecarts.registry.MMBlocks;
import com.alc.moreminecarts.registry.MMContainers;
import com.alc.moreminecarts.registry.MMEntities;
import com.alc.moreminecarts.registry.MMItems;
import com.alc.moreminecarts.registry.MMTileEntities;
import com.alc.moreminecarts.renderers.CampfireCartRenderer;
import com.alc.moreminecarts.renderers.CouplerRenderer;
import com.alc.moreminecarts.renderers.IronPushcartRenderer;
import com.alc.moreminecarts.renderers.PistonPushcartRenderer;
import com.alc.moreminecarts.renderers.SoulfireCartRenderer;
import com.alc.moreminecarts.renderers.StickyPistonPushcartRenderer;
import com.alc.moreminecarts.renderers.VanillaMinecartRenderer;
import com.alc.moreminecarts.renderers.WoodenPushcartRenderer;
import com.alc.moreminecarts.renderers.highspeed.HSMinecartRenderer;
import com.alc.moreminecarts.renderers.highspeed.HSPistonPushcartRenderer;
import com.alc.moreminecarts.renderers.highspeed.HSPushcartRenderer;
import com.alc.moreminecarts.renderers.highspeed.HSStickyPistonPushcartRenderer;
import java.util.Map;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="moreminecarts")
@Mod.EventBusSubscriber(modid="moreminecarts", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MoreMinecartsMod {
    public static Logger LOGGER = LogManager.getLogger();
    public static IProxy PROXY = (IProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);

    public MoreMinecartsMod() {
        MoreMinecartsPacketHandler.Init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerEntityRenderers);
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MMEntities.register(bus);
        MMBlocks.register(bus);
        MMItems.register(bus);
        MMTileEntities.register(bus);
        MMContainers.register(bus);
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        MMConstants.CONFIG_CHUNK_LOADER_MULTIPLIER = builder.defineInRange("chunk_loader_multiplier", () -> 1.0, 0.0, 9999.0);
        builder.comment("Requires that vitric cactus be grown only in desert and mesa biomes.");
        MMConstants.CONFIG_GLASS_CACTUS_DESERT_ONLY = builder.define("vitric_cactus_desert_only", true);
        builder.comment("Sets the max speed of various rail types. Default rails are 0.4.");
        MMConstants.CONFIG_WOOD_RAILS_MAX_SPEED = builder.defineInRange("wood_rails_max_speed", () -> 0.2, 0.1, 10.0);
        MMConstants.CONFIG_MAGLEV_RAILS_MAX_SPEED = builder.defineInRange("maglev_rails_max_speed", () -> 1.0, 0.1, 10.0);
        MMConstants.CONFIG_LIGHTSPEED_RAILS_MAX_SPEED = builder.defineInRange("lightspeed_rails_max_speed", () -> 2.5, 0.1, 10.0);
        builder.comment("Sets the extra speed boost given by turbo rails. 0.06 is the default for regular powered rails.");
        MMConstants.CONFIG_TURBO_BOOST = builder.defineInRange("turbo_rails_boost", () -> 0.2, 0.0, 1.0);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)builder.build(), "moreminecartsconfig.toml");
    }

    private void setup(FMLCommonSetupEvent event) {
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(new ResourceLocation("moreminecarts:chunkrodite_block"), MMBlocks.POTTED_BEET);
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(new ResourceLocation("moreminecarts:glass_cactus"), MMBlocks.POTTED_GLASS_CACTUS);
        MMConstants.WOODEN_MAX_SPEED = ((Double)MMConstants.CONFIG_WOOD_RAILS_MAX_SPEED.get()).floatValue();
        MMConstants.MAGLEV_MAX_SPEED = ((Double)MMConstants.CONFIG_MAGLEV_RAILS_MAX_SPEED.get()).floatValue();
        MMConstants.LIGHTSPEED_MAX_SPEED = ((Double)MMConstants.CONFIG_LIGHTSPEED_RAILS_MAX_SPEED.get()).floatValue();
        MMConstants.POWERED_LIGHTSPEED_BOOST = ((Double)MMConstants.CONFIG_TURBO_BOOST.get()).floatValue();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)MMContainers.CHUNK_LOADER_CONTAINER.get()), ChunkLoaderScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MMContainers.MINECART_LOADER_CONTAINER.get()), MinecartUnLoaderScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MMContainers.TANK_CART_CONTAINER.get()), TankCartScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MMContainers.BATTERY_CART_CONTAINER.get()), BatteryCartScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MMContainers.FLAG_CART_CONTAINER.get()), FlagCartScreen::new);
            RenderType cutout = RenderType.m_110463_();
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.RAIL_TURN.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.PARALLEL_RAIL_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.CROSS_RAIL_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.PROJECTOR_RAIL.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.HOLOGRAM_RAIL.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.WOODEN_RAIL_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.WOODEN_RAIL_TURN.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.WOODEN_PARALLEL_RAIL_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.WOODEN_CROSS_RAIL_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.WOODEN_PROJECTOR_RAIL.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.WOODEN_HOLOGRAM_RAIL.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.MAGLEV_RAIL_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.MAGLEV_RAIL_TURN.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.MAGLEV_PARALLEL_RAIL_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.MAGLEV_CROSS_RAIL_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.MAGLEV_PROJECTOR_RAIL.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.MAGLEV_HOLOGRAM_RAIL.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.MAGLEV_POWERED_RAIL_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.LIGHTSPEED_RAIL_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.LIGHTSPEED_CROSS_RAIL_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.LIGHTSPEED_POWERED_RAIL_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.BIOLUMINESCENT_RAIL_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.LOCKING_RAIL_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.POWERED_LOCKING_RAIL_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.PISTON_LIFTER_RAIL.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.ARITHMETIC_RAIL.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.CHUNK_LOADER_BLOCK.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.PEARL_STASIS_CHAMBER.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.HOLO_SCAFFOLD.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.CHAOTIC_HOLO_SCAFFOLD.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.GLASS_CACTUS.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.POTTED_BEET.get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.POTTED_GLASS_CACTUS.get()), (RenderType)cutout);
            for (Map.Entry<DyeColor, RegistryObject<Block>> entry : MMBlocks.COLOR_DETECTOR_RAILS.entrySet()) {
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)entry.getValue().get()), (RenderType)cutout);
            }
            RenderType transparent = RenderType.m_110466_();
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.ORGANIC_GLASS.get()), (RenderType)transparent);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.ORGANIC_GLASS_PANE.get()), (RenderType)transparent);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.CHISELED_ORGANIC_GLASS.get()), (RenderType)transparent);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MMBlocks.CHISELED_ORGANIC_GLASS_PANE.get()), (RenderType)transparent);
        });
    }

    @SubscribeEvent
    public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers evt) {
        evt.registerEntityRenderer((EntityType)MMEntities.MINECART_WITH_NET_ENTITY.get(), VanillaMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.CHUNK_LOADER_CART.get(), VanillaMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.ORB_STASIS_CART.get(), VanillaMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.FLAG_CART.get(), VanillaMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.CAMPFIRE_CART_ENTITY.get(), CampfireCartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.SOULFIRE_CART_ENTITY.get(), SoulfireCartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.WOODEN_PUSHCART_ENTITY.get(), WoodenPushcartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.IRON_PUSHCART_ENTITY.get(), IronPushcartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.PISTON_PUSHCART_ENTITY.get(), PistonPushcartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.STICKY_PISTON_PUSHCART_ENTITY.get(), StickyPistonPushcartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.TANK_CART_ENTITY.get(), VanillaMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.BATTERY_CART_ENTITY.get(), VanillaMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.COUPLER_ENTITY.get(), CouplerRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_CART_ENTITY.get(), HSMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_CHEST_CART_ENTITY.get(), HSMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_TNT_CART_ENTITY.get(), HSMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_COMMAND_BLOCK_CART_ENTITY.get(), HSMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_HOPPER_CART_ENTITY.get(), HSMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_SPAWNER_CART_ENTITY.get(), HSMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_FURNACE_CART_ENTITY.get(), HSMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_NET_CART_ENTITY.get(), HSMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_CHUNK_LOADER_CART_ENTITY.get(), HSMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_STASIS_CART_ENTITY.get(), HSMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_FLAG_CART_ENTITY.get(), HSMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_TANK_CART_ENTITY.get(), HSMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_BATTERY_CART_ENTITY.get(), HSMinecartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_CAMPFIRE_CART_ENTITY.get(), HSPushcartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_SOULFIRE_CART_ENTITY.get(), HSPushcartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_PUSHCART_ENTITY.get(), HSPushcartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_PISTON_PUSHCART_ENTITY.get(), HSPistonPushcartRenderer::new);
        evt.registerEntityRenderer((EntityType)MMEntities.HS_STICKY_PISTON_PUSHCART_ENTITY.get(), HSStickyPistonPushcartRenderer::new);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }
}

