/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.recipe;

import com.almostreliable.unified.api.recipe.RecipeContext;
import com.almostreliable.unified.utils.JsonUtils;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.UnifyTag;
import com.almostreliable.unified.utils.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class RecipeContextImpl
implements RecipeContext {
    private final ReplacementMap replacementMap;
    private final JsonObject originalRecipe;

    public RecipeContextImpl(JsonObject json, ReplacementMap replacementMap) {
        this.originalRecipe = json;
        this.replacementMap = replacementMap;
    }

    @Override
    @Nullable
    public ResourceLocation getReplacementForItem(@Nullable ResourceLocation item) {
        if (item == null) {
            return null;
        }
        return this.replacementMap.getReplacementForItem(item);
    }

    @Override
    @Nullable
    public ResourceLocation getPreferredItemForTag(@Nullable UnifyTag<Item> tag, Predicate<ResourceLocation> filter) {
        if (tag == null) {
            return null;
        }
        return this.replacementMap.getPreferredItemForTag(tag, filter);
    }

    @Override
    @Nullable
    public UnifyTag<Item> getPreferredTagForItem(@Nullable ResourceLocation item) {
        if (item == null) {
            return null;
        }
        return this.replacementMap.getPreferredTagForItem(item);
    }

    @Override
    @Nullable
    public JsonElement createIngredientReplacement(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        JsonElement copy = element.deepCopy();
        this.tryReplacingItemInIngredient(copy);
        return element.equals(copy) ? null : copy;
    }

    private void tryReplacingItemInIngredient(@Nullable JsonElement element) {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            for (JsonElement e : array) {
                this.tryReplacingItemInIngredient(e);
            }
        }
        if (element instanceof JsonObject) {
            JsonPrimitive primitive;
            ResourceLocation item;
            UnifyTag<Item> tag;
            JsonElement e;
            JsonObject object = (JsonObject)element;
            this.tryReplacingItemInIngredient(object.get("value"));
            this.tryReplacingItemInIngredient(object.get("ingredient"));
            e = object.get("item");
            if (e instanceof JsonPrimitive && (tag = this.getPreferredTagForItem(item = ResourceLocation.m_135820_((String)(primitive = (JsonPrimitive)e).getAsString()))) != null) {
                object.remove("item");
                object.add("tag", (JsonElement)new JsonPrimitive(tag.location().toString()));
            }
        }
    }

    @Override
    @Nullable
    public JsonElement createResultReplacement(@Nullable JsonElement element) {
        return this.createResultReplacement(element, true, "item");
    }

    @Override
    @Nullable
    public JsonElement createResultReplacement(@Nullable JsonElement element, boolean includeTagCheck, String ... lookupKeys) {
        if (element == null) {
            return null;
        }
        JsonElement copy = element.deepCopy();
        JsonElement result = this.tryCreateResultReplacement(copy, includeTagCheck, lookupKeys);
        return element.equals(result) ? null : result;
    }

    @Nullable
    public JsonElement tryCreateResultReplacement(JsonElement element, boolean lookupForTag, String ... keys) {
        JsonArray array;
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            ResourceLocation item = ResourceLocation.m_135820_((String)primitive.getAsString());
            ResourceLocation replacement = this.getReplacementForItem(item);
            if (replacement != null) {
                return new JsonPrimitive(replacement.toString());
            }
            return null;
        }
        if (element instanceof JsonArray && JsonUtils.replaceOn(array = (JsonArray)element, j -> this.tryCreateResultReplacement((JsonElement)j, lookupForTag, keys))) {
            return element;
        }
        if (element instanceof JsonObject) {
            JsonElement replacement;
            JsonObject object = (JsonObject)element;
            for (String key : keys) {
                if (!JsonUtils.replaceOn(object, key, j -> this.tryCreateResultReplacement((JsonElement)j, lookupForTag, keys))) continue;
                return element;
            }
            if (lookupForTag && (replacement = object.get("tag")) instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)replacement;
                ResourceLocation item = this.getPreferredItemForTag(Utils.toItemTag(primitive.getAsString()), $ -> true);
                if (item != null) {
                    object.remove("tag");
                    object.add("item", (JsonElement)new JsonPrimitive(item.toString()));
                }
                return element;
            }
        }
        return null;
    }

    @Override
    public ResourceLocation getType() {
        String type = this.originalRecipe.get("type").getAsString();
        return new ResourceLocation(type);
    }

    @Override
    public boolean hasProperty(String property) {
        return this.originalRecipe.has(property);
    }
}

