/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.api;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.Platform;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.UnifyTag;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class StoneStrataHandler {
    private final List<String> stoneStrata;
    private final Pattern tagMatcher;
    private final TagMap stoneStrataTagMap;

    private StoneStrataHandler(List<String> stoneStrata, Pattern tagMatcher, TagMap stoneStrataTagMap) {
        this.stoneStrata = stoneStrata;
        this.tagMatcher = tagMatcher;
        this.stoneStrataTagMap = stoneStrataTagMap;
    }

    public static StoneStrataHandler create(List<String> stoneStrataIds, Set<UnifyTag<Item>> stoneStrataTags, TagMap tagMap) {
        TagMap stoneStrataTagMap = tagMap.filtered(stoneStrataTags::contains, item -> true);
        Pattern tagMatcher = switch (AlmostUnifiedPlatform.INSTANCE.getPlatform()) {
            default -> throw new IncompatibleClassChangeError();
            case Platform.FORGE -> Pattern.compile("forge:ores/.+");
            case Platform.FABRIC -> Pattern.compile("(c:ores/.+|c:.+_ore)");
        };
        return new StoneStrataHandler(stoneStrataIds, tagMatcher, stoneStrataTagMap);
    }

    public String getStoneStrata(ResourceLocation item) {
        String strata = this.stoneStrataTagMap.getTags(item).stream().findFirst().map(UnifyTag::location).map(ResourceLocation::toString).map(s -> {
            int i = s.lastIndexOf(47);
            return i == -1 ? null : s.substring(i + 1);
        }).orElse(null);
        if (strata != null) {
            return strata;
        }
        for (String stone : this.stoneStrata) {
            if (!item.m_135815_().contains(stone + "_")) continue;
            return stone;
        }
        return "";
    }

    public boolean isStoneStrataTag(UnifyTag<Item> tag) {
        return this.tagMatcher.matcher(tag.location().toString()).matches();
    }
}

